rule win_alureon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.alureon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.alureon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895d14 7439 49 d1e9 41 894df8 8b4d14 }
            // n = 7, score = 200
            //   895d14               | mov                 dword ptr [ebp + 0x14], ebx
            //   7439                 | je                  0x3b
            //   49                   | dec                 ecx
            //   d1e9                 | shr                 ecx, 1
            //   41                   | inc                 ecx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]

        $sequence_1 = { 6a60 59 32c0 8d7c2420 }
            // n = 4, score = 200
            //   6a60                 | push                0x60
            //   59                   | pop                 ecx
            //   32c0                 | xor                 al, al
            //   8d7c2420             | lea                 edi, [esp + 0x20]

        $sequence_2 = { 45 33d2 0fb74158 d1e8 44 }
            // n = 5, score = 200
            //   45                   | inc                 ebp
            //   33d2                 | xor                 edx, edx
            //   0fb74158             | movzx               eax, word ptr [ecx + 0x58]
            //   d1e8                 | shr                 eax, 1
            //   44                   | inc                 esp

        $sequence_3 = { 49 8d541d2c 45 8be3 49 8bfb }
            // n = 6, score = 200
            //   49                   | dec                 ecx
            //   8d541d2c             | lea                 edx, [ebp + ebx + 0x2c]
            //   45                   | inc                 ebp
            //   8be3                 | mov                 esp, ebx
            //   49                   | dec                 ecx
            //   8bfb                 | mov                 edi, ebx

        $sequence_4 = { 8bc3 c1e808 88442440 8954242c }
            // n = 4, score = 200
            //   8bc3                 | mov                 eax, ebx
            //   c1e808               | shr                 eax, 8
            //   88442440             | mov                 byte ptr [esp + 0x40], al
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx

        $sequence_5 = { 68000010c0 8d45fc 50 c745d818000000 895ddc c745e440000000 895de8 }
            // n = 7, score = 200
            //   68000010c0           | push                0xc0100000
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   c745d818000000       | mov                 dword ptr [ebp - 0x28], 0x18
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx
            //   c745e440000000       | mov                 dword ptr [ebp - 0x1c], 0x40
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx

        $sequence_6 = { 49 8bfb 44 2b6330 8b0a 48 }
            // n = 6, score = 200
            //   49                   | dec                 ecx
            //   8bfb                 | mov                 edi, ebx
            //   44                   | inc                 esp
            //   2b6330               | sub                 esp, dword ptr [ebx + 0x30]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   48                   | dec                 eax

        $sequence_7 = { 668b85a0fbffff 8b4df4 8b3d???????? 66894108 }
            // n = 4, score = 200
            //   668b85a0fbffff       | mov                 ax, word ptr [ebp - 0x460]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b3d????????         |                     
            //   66894108             | mov                 word ptr [ecx + 8], ax

        $sequence_8 = { 5f 8d442454 89442428 8d442420 50 }
            // n = 5, score = 100
            //   5f                   | pop                 edi
            //   8d442454             | lea                 eax, [esp + 0x54]
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax

        $sequence_9 = { 75f9 ff75b4 8d4dbc 2bc6 8b35???????? 51 }
            // n = 6, score = 100
            //   75f9                 | jne                 0xfffffffb
            //   ff75b4               | push                dword ptr [ebp - 0x4c]
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   2bc6                 | sub                 eax, esi
            //   8b35????????         |                     
            //   51                   | push                ecx

        $sequence_10 = { 50 68???????? a4 ff15???????? 8bc3 8d7001 8a08 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   ff15????????         |                     
            //   8bc3                 | mov                 eax, ebx
            //   8d7001               | lea                 esi, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_11 = { ff742428 ff15???????? 8bf8 83ffff 7507 33c0 eb43 }
            // n = 7, score = 100
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83ffff               | cmp                 edi, -1
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   eb43                 | jmp                 0x45

        $sequence_12 = { beff000000 33db 56 8d85f9fcffff 53 50 }
            // n = 6, score = 100
            //   beff000000           | mov                 esi, 0xff
            //   33db                 | xor                 ebx, ebx
            //   56                   | push                esi
            //   8d85f9fcffff         | lea                 eax, [ebp - 0x307]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_13 = { 8d9c2400050000 e8???????? 8bc3 50 33db 53 53 }
            // n = 7, score = 100
            //   8d9c2400050000       | lea                 ebx, [esp + 0x500]
            //   e8????????           |                     
            //   8bc3                 | mov                 eax, ebx
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_14 = { 8bf8 83c418 85ff 7504 32c0 }
            // n = 5, score = 100
            //   8bf8                 | mov                 edi, eax
            //   83c418               | add                 esp, 0x18
            //   85ff                 | test                edi, edi
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al

        $sequence_15 = { e8???????? be00030000 83c418 8975ec c745f000010000 895df8 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   be00030000           | mov                 esi, 0x300
            //   83c418               | add                 esp, 0x18
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   c745f000010000       | mov                 dword ptr [ebp - 0x10], 0x100
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   56                   | push                esi

    condition:
        7 of them and filesize < 278528
}