rule win_anatova_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.anatova_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.anatova_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c89da 4c8b1d???????? 41ffd3 488b45d8 4989c3 }
            // n = 5, score = 200
            //   4c89da               | mov                 edx, eax
            //   4c8b1d????????       |                     
            //   41ffd3               | inc                 ecx
            //   488b45d8             | call                ebx
            //   4989c3               | dec                 eax

        $sequence_1 = { 4989c2 4c89d1 4c89da e8???????? 488b05???????? 4881c000020000 8b0d???????? }
            // n = 7, score = 200
            //   4989c2               | add                 byte ptr [eax], al
            //   4c89d1               | add                 byte ptr [eax], al
            //   4c89da               | dec                 ecx
            //   e8????????           |                     
            //   488b05????????       |                     
            //   4881c000020000       | mov                 ecx, eax
            //   8b0d????????         |                     

        $sequence_2 = { 0f8405000000 e9???????? 48b80000100000000000 e9???????? 488b45e8 48b90000000000000000 48894c2420 }
            // n = 7, score = 200
            //   0f8405000000         | dec                 eax
            //   e9????????           |                     
            //   48b80000100000000000     | cmp    eax, 0
            //   e9????????           |                     
            //   488b45e8             | je                  0xfc7
            //   48b90000000000000000     | dec    eax
            //   48894c2420           | cmp                 eax, 0

        $sequence_3 = { 488985c0feffff 488b85c0feffff b938020000 8908 488b85c0feffff 4989c3 }
            // n = 6, score = 200
            //   488985c0feffff       | dec                 ecx
            //   488b85c0feffff       | mov                 ebx, eax
            //   b938020000           | dec                 eax
            //   8908                 | mov                 eax, dword ptr [ebp - 8]
            //   488b85c0feffff       | dec                 ecx
            //   4989c3               | mov                 edx, eax

        $sequence_4 = { e8???????? 0fb645ff 83f800 0f846f020000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   0fb645ff             | dec                 eax
            //   83f800               | lea                 eax, [0x570b]
            //   0f846f020000         | dec                 ecx

        $sequence_5 = { 8845fe 0fb645fe 83f800 0f840d010000 }
            // n = 4, score = 200
            //   8845fe               | dec                 eax
            //   0fb645fe             | mov                 dword ptr [ebp - 0x50], eax
            //   83f800               | dec                 eax
            //   0f840d010000         | lea                 eax, [0x6560]

        $sequence_6 = { 488b4d10 4801c1 8b45fc 4863c0 }
            // n = 4, score = 200
            //   488b4d10             | mov                 dword ptr [ebp - 0x38], eax
            //   4801c1               | dec                 eax
            //   8b45fc               | lea                 eax, [0x6585]
            //   4863c0               | dec                 eax

        $sequence_7 = { 488b05???????? 4883f800 0f848f010000 488b05???????? 4883f800 0f847e010000 488b05???????? }
            // n = 7, score = 200
            //   488b05????????       |                     
            //   4883f800             | mov                 ebx, eax
            //   0f848f010000         | mov                 eax, 0x10000
            //   488b05????????       |                     
            //   4883f800             | dec                 ecx
            //   0f847e010000         | mov                 edx, eax
            //   488b05????????       |                     

        $sequence_8 = { b800000000 898574ffffff 8b8574ffffff 83f810 0f8dd3000000 }
            // n = 5, score = 200
            //   b800000000           | mov                 dword ptr [ebp - 8], eax
            //   898574ffffff         | dec                 eax
            //   8b8574ffffff         | mov                 eax, dword ptr [ebp + 0x10]
            //   83f810               | dec                 eax
            //   0f8dd3000000         | cmp                 eax, 0

        $sequence_9 = { 48b80f00000000000000 4989c0 b800000000 4989c3 488d45b1 4989c2 4c89d1 }
            // n = 7, score = 200
            //   48b80f00000000000000     | dec    eax
            //   4989c0               | lea                 eax, [ebp - 0x4f]
            //   b800000000           | dec                 ecx
            //   4989c3               | mov                 edx, eax
            //   488d45b1             | dec                 eax
            //   4989c2               | mov                 eax, 0x114
            //   4c89d1               | add                 byte ptr [eax], al

    condition:
        7 of them and filesize < 671744
}