rule win_andardoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.andardoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.andardoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? eb7d 33d2 488d8db0030000 41b808020000 e8???????? 33d2 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   eb7d                 | push                edi
            //   33d2                 | dec                 eax
            //   488d8db0030000       | sub                 esp, 0x20
            //   41b808020000         | dec                 eax
            //   e8????????           |                     
            //   33d2                 | mov                 ebx, edx

        $sequence_1 = { 90 0fb7840da8030000 6689840dd0040000 488d4902 6685c0 75e7 }
            // n = 6, score = 200
            //   90                   | dec                 eax
            //   0fb7840da8030000     | inc                 ebx
            //   6689840dd0040000     | cmp                 word ptr [eax + ebx*2], 0
            //   488d4902             | jne                 0x1be5
            //   6685c0               | add                 ebx, ebx
            //   75e7                 | mov                 dword ptr [esp + 0x44], ebx

        $sequence_2 = { 75f4 4c8d043f 488d9560030000 488d4c2468 e8???????? 488b35???????? }
            // n = 6, score = 200
            //   75f4                 | dec                 eax
            //   4c8d043f             | lea                 edx, [eax + 2]
            //   488d9560030000       | dec                 eax
            //   488d4c2468           | lea                 ebx, [0x213ad]
            //   e8????????           |                     
            //   488b35????????       |                     

        $sequence_3 = { 488b05???????? 4833c4 4889842450400000 33c0 }
            // n = 4, score = 200
            //   488b05????????       |                     
            //   4833c4               | nop                 
            //   4889842450400000     | dec                 eax
            //   33c0                 | inc                 ebx

        $sequence_4 = { 482bfe 0f1f4000 660f1f840000000000 0fb701 }
            // n = 4, score = 200
            //   482bfe               | lea                 edx, [0x1c644]
            //   0f1f4000             | inc                 ecx
            //   660f1f840000000000     | mov    eax, 0x80
            //   0fb701               | inc                 esp

        $sequence_5 = { 4d894bc8 458a4b28 498943e8 488b8424b0000000 498953b8 498d53b8 4d8943c0 }
            // n = 7, score = 200
            //   4d894bc8             | mov                 ebx, eax
            //   458a4b28             | dec                 eax
            //   498943e8             | test                eax, eax
            //   488b8424b0000000     | je                  0x907
            //   498953b8             | nop                 
            //   498d53b8             | dec                 eax
            //   4d8943c0             | lea                 edx, [0x9e20]

        $sequence_6 = { 488d4c2440 ff15???????? 85c0 7551 }
            // n = 4, score = 200
            //   488d4c2440           | cmp                 byte ptr [ebx], bh
            //   ff15????????         |                     
            //   85c0                 | je                  0x11a3
            //   7551                 | nop                 dword ptr [eax]

        $sequence_7 = { 488bc8 e8???????? e8???????? 488b0d???????? 488d542450 4881c108020000 c744245004010000 }
            // n = 7, score = 200
            //   488bc8               | lea                 eax, [edi + edi]
            //   e8????????           |                     
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   488d542450           | dec                 eax
            //   4881c108020000       | lea                 edx, [ebp + 0x360]
            //   c744245004010000     | dec                 eax

        $sequence_8 = { 498bc8 498bd8 e8???????? 33c9 85c0 }
            // n = 5, score = 200
            //   498bc8               | dec                 esp
            //   498bd8               | lea                 ebx, [esp + 0x3f0]
            //   e8????????           |                     
            //   33c9                 | dec                 ecx
            //   85c0                 | mov                 ebx, dword ptr [ebx + 0x28]

        $sequence_9 = { 4883cfff 0f1f8000000000 664439647802 488d7f01 75f4 4c8d043f 488d9560030000 }
            // n = 7, score = 200
            //   4883cfff             | mov                 ecx, 0x202
            //   0f1f8000000000       | dec                 eax
            //   664439647802         | mov                 dword ptr [ebx], eax
            //   488d7f01             | dec                 eax
            //   75f4                 | mov                 dword ptr [ebx + 8], eax
            //   4c8d043f             | dec                 eax
            //   488d9560030000       | mov                 dword ptr [ebx + 0x10], eax

    condition:
        7 of them and filesize < 339968
}