rule win_andromut_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.andromut."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.andromut"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d8da0dfffff 51 6819000200 56 8d4da4 51 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8d8da0dfffff         | lea                 ecx, [ebp - 0x2060]
            //   51                   | push                ecx
            //   6819000200           | push                0x20019
            //   56                   | push                esi
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   51                   | push                ecx

        $sequence_1 = { 47 3bfb 72e9 8b75fc 8b45f8 8b7c1018 33db }
            // n = 7, score = 200
            //   47                   | inc                 edi
            //   3bfb                 | cmp                 edi, ebx
            //   72e9                 | jb                  0xffffffeb
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b7c1018             | mov                 edi, dword ptr [eax + edx + 0x18]
            //   33db                 | xor                 ebx, ebx

        $sequence_2 = { 8d8db8f9ffff 51 8d8d70f9ffff 51 57 57 }
            // n = 6, score = 200
            //   8d8db8f9ffff         | lea                 ecx, [ebp - 0x648]
            //   51                   | push                ecx
            //   8d8d70f9ffff         | lea                 ecx, [ebp - 0x690]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   57                   | push                edi

        $sequence_3 = { 53 51 ffb5a0f7ffff 8d8590f7ffff b92d57ae5b 0f438590f7ffff }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   ffb5a0f7ffff         | push                dword ptr [ebp - 0x860]
            //   8d8590f7ffff         | lea                 eax, [ebp - 0x870]
            //   b92d57ae5b           | mov                 ecx, 0x5bae572d
            //   0f438590f7ffff       | cmovae              eax, dword ptr [ebp - 0x870]

        $sequence_4 = { 8a4d08 8d41bf 3c19 7708 0fbed1 83ea41 eb34 }
            // n = 7, score = 200
            //   8a4d08               | mov                 cl, byte ptr [ebp + 8]
            //   8d41bf               | lea                 eax, [ecx - 0x41]
            //   3c19                 | cmp                 al, 0x19
            //   7708                 | ja                  0xa
            //   0fbed1               | movsx               edx, cl
            //   83ea41               | sub                 edx, 0x41
            //   eb34                 | jmp                 0x36

        $sequence_5 = { 8d44246c b974723dc5 50 8d84247c030000 50 e8???????? }
            // n = 6, score = 200
            //   8d44246c             | lea                 eax, [esp + 0x6c]
            //   b974723dc5           | mov                 ecx, 0xc53d7274
            //   50                   | push                eax
            //   8d84247c030000       | lea                 eax, [esp + 0x37c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 49 8bc1 c1e10b c1e805 25ff070000 0bc1 }
            // n = 6, score = 200
            //   49                   | dec                 ecx
            //   8bc1                 | mov                 eax, ecx
            //   c1e10b               | shl                 ecx, 0xb
            //   c1e805               | shr                 eax, 5
            //   25ff070000           | and                 eax, 0x7ff
            //   0bc1                 | or                  eax, ecx

        $sequence_7 = { 8b9d70ffffff 8b856cffffff 03df a801 7415 6aff }
            // n = 6, score = 200
            //   8b9d70ffffff         | mov                 ebx, dword ptr [ebp - 0x90]
            //   8b856cffffff         | mov                 eax, dword ptr [ebp - 0x94]
            //   03df                 | add                 ebx, edi
            //   a801                 | test                al, 1
            //   7415                 | je                  0x17
            //   6aff                 | push                -1

        $sequence_8 = { b802210000 6689443e16 0fb7443e06 8b75f8 }
            // n = 4, score = 200
            //   b802210000           | mov                 eax, 0x2102
            //   6689443e16           | mov                 word ptr [esi + edi + 0x16], ax
            //   0fb7443e06           | movzx               eax, word ptr [esi + edi + 6]
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]

        $sequence_9 = { e8???????? 8be5 5d c3 68c8060000 b8???????? e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   68c8060000           | push                0x6c8
            //   b8????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 368640
}