rule win_apollo_shadow_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.apollo_shadow."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.apollo_shadow"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bce e8???????? 4183ceff 488d0590880200 4a8b04f8 42f644e03801 }
            // n = 6, score = 100
            //   8bce                 | mov                 eax, dword ptr [ebp - 0x30]
            //   e8????????           |                     
            //   4183ceff             | dec                 eax
            //   488d0590880200       | shr                 eax, 0x20
            //   4a8b04f8             | mov                 eax, dword ptr [ebx + 0x468]
            //   42f644e03801         | inc                 eax

        $sequence_1 = { 48898424e0000000 488bf1 48894c2458 4533f6 4489742430 0f57c0 }
            // n = 6, score = 100
            //   48898424e0000000     | push                edi
            //   488bf1               | dec                 eax
            //   48894c2458           | sub                 esp, 0x20
            //   4533f6               | inc                 ecx
            //   4489742430           | mov                 esi, eax
            //   0f57c0               | dec                 esp

        $sequence_2 = { 48b8033bae3ba217f877 488945a7 488b75a7 48b8b89c83748f3838d7 488945a7 488b5da7 48b89553bf5390096f5f }
            // n = 7, score = 100
            //   48b8033bae3ba217f877     | lea    ebx, [0xfffda695]
            //   488945a7             | dec                 eax
            //   488b75a7             | mov                 edx, edi
            //   48b8b89c83748f3838d7     | dec    eax
            //   488945a7             | lea                 ecx, [ebp - 1]
            //   488b5da7             | dec                 eax
            //   48b89553bf5390096f5f     | lea    edi, [0x48911]

        $sequence_3 = { 48b8ffffffffffffff7f 483bc8 0f8793000000 4803c9 4881f900100000 7224 488d4127 }
            // n = 7, score = 100
            //   48b8ffffffffffffff7f     | dec    eax
            //   483bc8               | lea                 ecx, [edx + 0x40]
            //   0f8793000000         | dec                 eax
            //   4803c9               | lea                 ecx, [edx + 0xa4]
            //   4881f900100000       | dec                 eax
            //   7224                 | lea                 ecx, [edx + 0x158]
            //   488d4127             | dec                 eax

        $sequence_4 = { 48837d3708 480f43451f 48894d2f 66891c48 eb57 488bd1 }
            // n = 6, score = 100
            //   48837d3708           | mov                 edx, dword ptr [ebp + 0x77]
            //   480f43451f           | dec                 eax
            //   48894d2f             | lea                 eax, [0x23a91]
            //   66891c48             | dec                 eax
            //   eb57                 | sub                 esp, 0xe0
            //   488bd1               | dec                 eax

        $sequence_5 = { 4053 4883ec20 b908000000 e8???????? 488bd8 4889442430 48c70001000080 }
            // n = 7, score = 100
            //   4053                 | mov                 dword ptr [ebp], eax
            //   4883ec20             | dec                 eax
            //   b908000000           | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   488bd8               | nop                 
            //   4889442430           | xorps               xmm0, xmm0
            //   48c70001000080       | xor                 eax, eax

        $sequence_6 = { 0f28458f 33ff 4c8d7dc7 48837ddf08 4c0f437dc7 }
            // n = 5, score = 100
            //   0f28458f             | dec                 esp
            //   33ff                 | mov                 eax, dword ptr [edx]
            //   4c8d7dc7             | dec                 esp
            //   48837ddf08           | lea                 ebx, [0xfffe553a]
            //   4c0f437dc7           | dec                 esp

        $sequence_7 = { 448b10 410fb609 83e10f 4a0fbe8431489d0300 428a8c31589d0300 4c2bc8 418b41fc }
            // n = 7, score = 100
            //   448b10               | mov                 eax, 0x101
            //   410fb609             | inc                 ecx
            //   83e10f               | mov                 eax, esi
            //   4a0fbe8431489d0300     | dec    ebp
            //   428a8c31589d0300     | lea                 ecx, [esp + 0x10]
            //   4c2bc8               | dec                 esp
            //   418b41fc             | lea                 ebx, [0x1f6c5]

        $sequence_8 = { c744242804000000 488d842480000000 4889442420 41b904000000 4533c0 488b0f ff15???????? }
            // n = 7, score = 100
            //   c744242804000000     | dec                 eax
            //   488d842480000000     | lea                 edx, [0x31a5b]
            //   4889442420           | ret                 
            //   41b904000000         | mov                 dl, 1
            //   4533c0               | dec                 eax
            //   488b0f               | mov                 ecx, ebx
            //   ff15????????         |                     

        $sequence_9 = { f3410f7f01 f30f7e4108 660f60c0 660f71e008 f3410f7f4110 f30f7e4110 660f60c0 }
            // n = 7, score = 100
            //   f3410f7f01           | nop                 
            //   f30f7e4108           | dec                 eax
            //   660f60c0             | mov                 edi, dword ptr [esp + 0xc0]
            //   660f71e008           | xorps               xmm0, xmm0
            //   f3410f7f4110         | movups              xmmword ptr [esp + 0x38], xmm0
            //   f30f7e4110           | dec                 esp
            //   660f60c0             | mov                 dword ptr [esp + 0x48], esi

    condition:
        7 of them and filesize < 710656
}