rule win_applejeus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.applejeus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.applejeus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bb540eeffff 56 ff15???????? 56 ffd7 ffb5e0edffff ffd7 }
            // n = 7, score = 200
            //   8bb540eeffff         | mov                 esi, dword ptr [ebp - 0x11c0]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   ffb5e0edffff         | push                dword ptr [ebp - 0x1220]
            //   ffd7                 | call                edi

        $sequence_1 = { 8bc8 51 e8???????? 83c404 c7460800000000 c7460400000000 ff36 }
            // n = 7, score = 200
            //   8bc8                 | mov                 ecx, eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0
            //   c7460400000000       | mov                 dword ptr [esi + 4], 0
            //   ff36                 | push                dword ptr [esi]

        $sequence_2 = { 8b75e4 83c410 0bf0 c745d8d4b24500 8d45dc 50 e8???????? }
            // n = 7, score = 200
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   83c410               | add                 esp, 0x10
            //   0bf0                 | or                  esi, eax
            //   c745d8d4b24500       | mov                 dword ptr [ebp - 0x28], 0x45b2d4
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 8bf8 ffd6 ffb5b0fdffff 8bb588feffff 8bc8 b8ed73484d }
            // n = 6, score = 200
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   ffb5b0fdffff         | push                dword ptr [ebp - 0x250]
            //   8bb588feffff         | mov                 esi, dword ptr [ebp - 0x178]
            //   8bc8                 | mov                 ecx, eax
            //   b8ed73484d           | mov                 eax, 0x4d4873ed

        $sequence_4 = { 897008 e8???????? 8d8dd8ecffff e8???????? 8d8dd4efffff e8???????? 6a64 }
            // n = 7, score = 200
            //   897008               | mov                 dword ptr [eax + 8], esi
            //   e8????????           |                     
            //   8d8dd8ecffff         | lea                 ecx, [ebp - 0x1328]
            //   e8????????           |                     
            //   8d8dd4efffff         | lea                 ecx, [ebp - 0x102c]
            //   e8????????           |                     
            //   6a64                 | push                0x64

        $sequence_5 = { 6a08 c645fc16 e8???????? 83c404 8985e4f6ffff 898568f4ffff c700???????? }
            // n = 7, score = 200
            //   6a08                 | push                8
            //   c645fc16             | mov                 byte ptr [ebp - 4], 0x16
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8985e4f6ffff         | mov                 dword ptr [ebp - 0x91c], eax
            //   898568f4ffff         | mov                 dword ptr [ebp - 0xb98], eax
            //   c700????????         |                     

        $sequence_6 = { 0f84d3000000 8b048d74db4500 8985a4f8ffff 85c0 0f8498000000 83f801 0f84b5000000 }
            // n = 7, score = 200
            //   0f84d3000000         | je                  0xd9
            //   8b048d74db4500       | mov                 eax, dword ptr [ecx*4 + 0x45db74]
            //   8985a4f8ffff         | mov                 dword ptr [ebp - 0x75c], eax
            //   85c0                 | test                eax, eax
            //   0f8498000000         | je                  0x9e
            //   83f801               | cmp                 eax, 1
            //   0f84b5000000         | je                  0xbb

        $sequence_7 = { 8bf0 6a0c 8975e4 8975d0 0f114604 c706???????? f30f7e45c4 }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   6a0c                 | push                0xc
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   8975d0               | mov                 dword ptr [ebp - 0x30], esi
            //   0f114604             | movups              xmmword ptr [esi + 4], xmm0
            //   c706????????         |                     
            //   f30f7e45c4           | movq                xmm0, qword ptr [ebp - 0x3c]

        $sequence_8 = { 8885fcfcffff 8b85dcfcffff 041d 83f05c 8885fdfcffff 8b85dcfcffff }
            // n = 6, score = 200
            //   8885fcfcffff         | mov                 byte ptr [ebp - 0x304], al
            //   8b85dcfcffff         | mov                 eax, dword ptr [ebp - 0x324]
            //   041d                 | add                 al, 0x1d
            //   83f05c               | xor                 eax, 0x5c
            //   8885fdfcffff         | mov                 byte ptr [ebp - 0x303], al
            //   8b85dcfcffff         | mov                 eax, dword ptr [ebp - 0x324]

        $sequence_9 = { 8b4308 33ff 807e2c00 8945c4 0f842e010000 8b4808 0f57c0 }
            // n = 7, score = 200
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   33ff                 | xor                 edi, edi
            //   807e2c00             | cmp                 byte ptr [esi + 0x2c], 0
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   0f842e010000         | je                  0x134
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   0f57c0               | xorps               xmm0, xmm0

    condition:
        7 of them and filesize < 1245184
}