rule win_appleseed_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.appleseed."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.appleseed"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4989742410 41c6042400 49837f1810 7208 498b0f e8???????? 49c747180f000000 }
            // n = 7, score = 100
            //   4989742410           | dec                 eax
            //   41c6042400           | xor                 ecx, esp
            //   49837f1810           | dec                 eax
            //   7208                 | mov                 ebx, dword ptr [esp + 0xf8]
            //   498b0f               | mov                 byte ptr [ecx + 0x18], 1
            //   e8????????           |                     
            //   49c747180f000000     | dec                 ecx

        $sequence_1 = { 0f8414010000 488d15d2160200 488d4db8 e8???????? 90 488d55d8 488bc8 }
            // n = 7, score = 100
            //   0f8414010000         | dec                 eax
            //   488d15d2160200       | mov                 edx, eax
            //   488d4db8             | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 eax, dword ptr [edi + 0x18]
            //   488d55d8             | dec                 eax
            //   488bc8               | mov                 dword ptr [eax + ebp*8], edx

        $sequence_2 = { 48894c2470 33f6 89742440 48c741180f000000 48897110 408831 4533c0 }
            // n = 7, score = 100
            //   48894c2470           | dec                 eax
            //   33f6                 | lea                 ecx, [ebp + 0x10]
            //   89742440             | nop                 
            //   48c741180f000000     | dec                 eax
            //   48897110             | cmp                 dword ptr [ebx + 0x18], 0x10
            //   408831               | jb                  0xf47
            //   4533c0               | dec                 eax

        $sequence_3 = { 48837dd010 7209 488b4db8 e8???????? 48833d????????00 0f847c180000 48c745d00f000000 }
            // n = 7, score = 100
            //   48837dd010           | dec                 eax
            //   7209                 | lea                 edx, [0x21bb7]
            //   488b4db8             | dec                 eax
            //   e8????????           |                     
            //   48833d????????00     |                     
            //   0f847c180000         | lea                 ecx, [ebp - 0x48]
            //   48c745d00f000000     | nop                 

        $sequence_4 = { 480f434daf 488b5d07 4c8bc3 4c8b75bf 4c3bf3 4d0f42c6 4d85c0 }
            // n = 7, score = 100
            //   480f434daf           | dec                 eax
            //   488b5d07             | sar                 ecx, 5
            //   4c8bc3               | dec                 ebp
            //   4c8b75bf             | imul                eax, eax, 0x58
            //   4c3bf3               | dec                 esp
            //   4d0f42c6             | add                 eax, dword ptr [eax + ecx*8 + 0x36700]
            //   4d85c0               | jmp                 0xaf2

        $sequence_5 = { 4889742440 4088742430 448d463c 488d1524b40100 488d4c2430 e8???????? 90 }
            // n = 7, score = 100
            //   4889742440           | dec                 eax
            //   4088742430           | lea                 edx, [0x2191d]
            //   448d463c             | dec                 eax
            //   488d1524b40100       | lea                 ecx, [ebp - 0x48]
            //   488d4c2430           | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 ecx, [ebp - 0x48]

        $sequence_6 = { 488b5c2438 4883c420 5e c3 488d0d887c0200 e8???????? }
            // n = 6, score = 100
            //   488b5c2438           | dec                 eax
            //   4883c420             | lea                 edx, [ebp + 0x10]
            //   5e                   | dec                 eax
            //   c3                   | lea                 ecx, [esp + 0x50]
            //   488d0d887c0200       | dec                 ecx
            //   e8????????           |                     

        $sequence_7 = { 48897310 c60300 48837d9810 7209 488b4d80 }
            // n = 5, score = 100
            //   48897310             | dec                 eax
            //   c60300               | mov                 edx, eax
            //   48837d9810           | dec                 eax
            //   7209                 | lea                 ecx, [ebp - 0x78]
            //   488b4d80             | nop                 

        $sequence_8 = { e8???????? 488325????????00 4883c428 c3 488d05310a0200 c3 4053 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488325????????00     |                     
            //   4883c428             | dec                 eax
            //   c3                   | lea                 eax, [ebp - 0x80]
            //   488d05310a0200       | dec                 ecx
            //   c3                   | or                  eax, 0xffffffff
            //   4053                 | inc                 esp

        $sequence_9 = { 488bfa 488bf1 4533f6 4489742460 44887580 33d2 41b8ff030000 }
            // n = 7, score = 100
            //   488bfa               | lea                 esi, [0x2075d]
            //   488bf1               | dec                 esp
            //   4533f6               | lea                 edi, [0x2075a]
            //   4489742460           | dec                 esp
            //   44887580             | lea                 esp, [0x20757]
            //   33d2                 | dec                 ebp
            //   41b8ff030000         | sub                 edi, edx

    condition:
        7 of them and filesize < 497664
}