rule win_aresloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.aresloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aresloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895c2404 893424 e8???????? 85c0 7831 39d8 7205 }
            // n = 7, score = 400
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7831                 | js                  0x33
            //   39d8                 | cmp                 eax, ebx
            //   7205                 | jb                  7

        $sequence_1 = { 39d8 7205 c6441eff00 83c41c 5b }
            // n = 5, score = 400
            //   39d8                 | cmp                 eax, ebx
            //   7205                 | jb                  7
            //   c6441eff00           | mov                 byte ptr [esi + ebx - 1], 0
            //   83c41c               | add                 esp, 0x1c
            //   5b                   | pop                 ebx

        $sequence_2 = { 83ec1c 8b5c2434 8b742430 8b7c2438 8b6c243c 85db 7435 }
            // n = 7, score = 400
            //   83ec1c               | sub                 esp, 0x1c
            //   8b5c2434             | mov                 ebx, dword ptr [esp + 0x34]
            //   8b742430             | mov                 esi, dword ptr [esp + 0x30]
            //   8b7c2438             | mov                 edi, dword ptr [esp + 0x38]
            //   8b6c243c             | mov                 ebp, dword ptr [esp + 0x3c]
            //   85db                 | test                ebx, ebx
            //   7435                 | je                  0x37

        $sequence_3 = { 8b6c243c 85db 7435 85f6 7431 }
            // n = 5, score = 400
            //   8b6c243c             | mov                 ebp, dword ptr [esp + 0x3c]
            //   85db                 | test                ebx, ebx
            //   7435                 | je                  0x37
            //   85f6                 | test                esi, esi
            //   7431                 | je                  0x33

        $sequence_4 = { 85f6 7431 896c240c 897c2408 895c2404 }
            // n = 5, score = 400
            //   85f6                 | test                esi, esi
            //   7431                 | je                  0x33
            //   896c240c             | mov                 dword ptr [esp + 0xc], ebp
            //   897c2408             | mov                 dword ptr [esp + 8], edi
            //   895c2404             | mov                 dword ptr [esp + 4], ebx

        $sequence_5 = { 85db 7435 85f6 7431 896c240c }
            // n = 5, score = 400
            //   85db                 | test                ebx, ebx
            //   7435                 | je                  0x37
            //   85f6                 | test                esi, esi
            //   7431                 | je                  0x33
            //   896c240c             | mov                 dword ptr [esp + 0xc], ebp

        $sequence_6 = { 8b5c2434 8b742430 8b7c2438 8b6c243c 85db 7435 85f6 }
            // n = 7, score = 400
            //   8b5c2434             | mov                 ebx, dword ptr [esp + 0x34]
            //   8b742430             | mov                 esi, dword ptr [esp + 0x30]
            //   8b7c2438             | mov                 edi, dword ptr [esp + 0x38]
            //   8b6c243c             | mov                 ebp, dword ptr [esp + 0x3c]
            //   85db                 | test                ebx, ebx
            //   7435                 | je                  0x37
            //   85f6                 | test                esi, esi

        $sequence_7 = { 85c0 7831 39d8 7205 }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   7831                 | js                  0x33
            //   39d8                 | cmp                 eax, ebx
            //   7205                 | jb                  7

        $sequence_8 = { 7431 896c240c 897c2408 895c2404 893424 }
            // n = 5, score = 400
            //   7431                 | je                  0x33
            //   896c240c             | mov                 dword ptr [esp + 0xc], ebp
            //   897c2408             | mov                 dword ptr [esp + 8], edi
            //   895c2404             | mov                 dword ptr [esp + 4], ebx
            //   893424               | mov                 dword ptr [esp], esi

        $sequence_9 = { e8???????? 85c0 7831 39d8 7205 c6441eff00 83c41c }
            // n = 7, score = 400
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7831                 | js                  0x33
            //   39d8                 | cmp                 eax, ebx
            //   7205                 | jb                  7
            //   c6441eff00           | mov                 byte ptr [esi + ebx - 1], 0
            //   83c41c               | add                 esp, 0x1c

    condition:
        7 of them and filesize < 2657280
}