rule win_arik_keylogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.arik_keylogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.arik_keylogger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b8???????? e8???????? 83f801 0f85cb000000 8d45b8 e8???????? c745b800000000 }
            // n = 7, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1
            //   0f85cb000000         | jne                 0xd1
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   e8????????           |                     
            //   c745b800000000       | mov                 dword ptr [ebp - 0x48], 0

        $sequence_1 = { 8d55b0 e8???????? 8b55b0 8d45ac b9???????? e8???????? 8b55ac }
            // n = 7, score = 200
            //   8d55b0               | lea                 edx, [ebp - 0x50]
            //   e8????????           |                     
            //   8b55b0               | mov                 edx, dword ptr [ebp - 0x50]
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   b9????????           |                     
            //   e8????????           |                     
            //   8b55ac               | mov                 edx, dword ptr [ebp - 0x54]

        $sequence_2 = { e8???????? 8b45f8 80780700 740b 8d55f0 8b45f8 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   80780700             | cmp                 byte ptr [eax + 7], 0
            //   740b                 | je                  0xd
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     

        $sequence_3 = { e8???????? 84c0 741d 6a00 6a00 68c6000000 8b45fc }
            // n = 7, score = 200
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   741d                 | je                  0x1f
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68c6000000           | push                0xc6
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_4 = { c645f400 8b55fc b8???????? e8???????? 84c0 0f84b3010000 8b45fc }
            // n = 7, score = 200
            //   c645f400             | mov                 byte ptr [ebp - 0xc], 0
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   b8????????           |                     
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f84b3010000         | je                  0x1b9
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { e8???????? 89c1 81f9ff000000 7605 e8???????? 8802 eb08 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   89c1                 | mov                 ecx, eax
            //   81f9ff000000         | cmp                 ecx, 0xff
            //   7605                 | jbe                 7
            //   e8????????           |                     
            //   8802                 | mov                 byte ptr [edx], al
            //   eb08                 | jmp                 0xa

        $sequence_6 = { e8???????? 88459c 8b45a8 48 83f804 7723 ff248590826100 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   88459c               | mov                 byte ptr [ebp - 0x64], al
            //   8b45a8               | mov                 eax, dword ptr [ebp - 0x58]
            //   48                   | dec                 eax
            //   83f804               | cmp                 eax, 4
            //   7723                 | ja                  0x25
            //   ff248590826100       | jmp                 dword ptr [eax*4 + 0x618290]

        $sequence_7 = { e8???????? c745d000000000 8d4dd0 89d8 ba07000000 8b33 ff5678 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   89d8                 | mov                 eax, ebx
            //   ba07000000           | mov                 edx, 7
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   ff5678               | call                dword ptr [esi + 0x78]

        $sequence_8 = { 8d45e4 baffffffff e8???????? 8945f8 c645ec00 8d4dd8 8d55c0 }
            // n = 7, score = 200
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   baffffffff           | mov                 edx, 0xffffffff
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   c645ec00             | mov                 byte ptr [ebp - 0x14], 0
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   8d55c0               | lea                 edx, [ebp - 0x40]

        $sequence_9 = { b8???????? e8???????? 84c0 741b 8b45fc 8b80a8020000 8b55f4 }
            // n = 7, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   741b                 | je                  0x1d
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b80a8020000         | mov                 eax, dword ptr [eax + 0x2a8]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 4947968
}