rule win_artfulpie_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.artfulpie."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.artfulpie"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 0f8527010000 0f1f4000 8b430c 85c0 0f8418010000 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8527010000         | jne                 0x12d
            //   0f1f4000             | nop                 dword ptr [eax]
            //   8b430c               | mov                 eax, dword ptr [ebx + 0xc]
            //   85c0                 | test                eax, eax
            //   0f8418010000         | je                  0x11e

        $sequence_1 = { c745fc00000000 85c0 7406 50 e8???????? 8b4df4 b801000000 }
            // n = 7, score = 200
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   b801000000           | mov                 eax, 1

        $sequence_2 = { 8db8b44b4100 57 ff15???????? ff0d???????? 83ef18 }
            // n = 5, score = 200
            //   8db8b44b4100         | lea                 edi, [eax + 0x414bb4]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff0d????????         |                     
            //   83ef18               | sub                 edi, 0x18

        $sequence_3 = { 894de0 8b049d984e4100 0fb6440828 83e001 }
            // n = 4, score = 200
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   8b049d984e4100       | mov                 eax, dword ptr [ebx*4 + 0x414e98]
            //   0fb6440828           | movzx               eax, byte ptr [eax + ecx + 0x28]
            //   83e001               | and                 eax, 1

        $sequence_4 = { 50 ffd2 85c0 7477 8b46fc 57 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   85c0                 | test                eax, eax
            //   7477                 | je                  0x79
            //   8b46fc               | mov                 eax, dword ptr [esi - 4]
            //   57                   | push                edi

        $sequence_5 = { c745ec00000000 50 8d45ec c745e404000000 50 }
            // n = 5, score = 200
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   c745e404000000       | mov                 dword ptr [ebp - 0x1c], 4
            //   50                   | push                eax

        $sequence_6 = { 85c0 0f84af000000 6a04 6800100000 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   0f84af000000         | je                  0xb5
            //   6a04                 | push                4
            //   6800100000           | push                0x1000

        $sequence_7 = { 8b3e 8b4630 48 f7d0 }
            // n = 4, score = 200
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   8b4630               | mov                 eax, dword ptr [esi + 0x30]
            //   48                   | dec                 eax
            //   f7d0                 | not                 eax

        $sequence_8 = { 6af6 ff15???????? 8b04bd984e4100 834c0318ff 33c0 }
            // n = 5, score = 200
            //   6af6                 | push                -0xa
            //   ff15????????         |                     
            //   8b04bd984e4100       | mov                 eax, dword ptr [edi*4 + 0x414e98]
            //   834c0318ff           | or                  dword ptr [ebx + eax + 0x18], 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { f00fc118 4b 7515 8b45fc 817848f8444100 7409 }
            // n = 6, score = 200
            //   f00fc118             | lock xadd           dword ptr [eax], ebx
            //   4b                   | dec                 ebx
            //   7515                 | jne                 0x17
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   817848f8444100       | cmp                 dword ptr [eax + 0x48], 0x4144f8
            //   7409                 | je                  0xb

    condition:
        7 of them and filesize < 204800
}