rule win_asprox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.asprox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.asprox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8955d4 eb05 e9???????? 8b45d4 898538ffffff c6459447 }
            // n = 6, score = 1200
            //   8955d4               | mov                 dword ptr [ebp - 0x2c], edx
            //   eb05                 | jmp                 7
            //   e9????????           |                     
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   898538ffffff         | mov                 dword ptr [ebp - 0xc8], eax
            //   c6459447             | mov                 byte ptr [ebp - 0x6c], 0x47

        $sequence_1 = { e9???????? 8b03 83780400 0f84fe070000 8b10 0fb612 8b4b1c }
            // n = 7, score = 1200
            //   e9????????           |                     
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   83780400             | cmp                 dword ptr [eax + 4], 0
            //   0f84fe070000         | je                  0x804
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   0fb612               | movzx               edx, byte ptr [edx]
            //   8b4b1c               | mov                 ecx, dword ptr [ebx + 0x1c]

        $sequence_2 = { 038cfe94c90000 0394fe98c90000 668945d0 c1e810 66894dd4 c1e910 668955d8 }
            // n = 7, score = 1200
            //   038cfe94c90000       | add                 ecx, dword ptr [esi + edi*8 + 0xc994]
            //   0394fe98c90000       | add                 edx, dword ptr [esi + edi*8 + 0xc998]
            //   668945d0             | mov                 word ptr [ebp - 0x30], ax
            //   c1e810               | shr                 eax, 0x10
            //   66894dd4             | mov                 word ptr [ebp - 0x2c], cx
            //   c1e910               | shr                 ecx, 0x10
            //   668955d8             | mov                 word ptr [ebp - 0x28], dx

        $sequence_3 = { c645f300 6800100000 6a00 a1???????? 50 ff15???????? 8945f8 }
            // n = 7, score = 1200
            //   c645f300             | mov                 byte ptr [ebp - 0xd], 0
            //   6800100000           | push                0x1000
            //   6a00                 | push                0
            //   a1????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_4 = { 49 7407 33c0 e9???????? 3bd3 0f858d000000 8b4e0c }
            // n = 7, score = 1200
            //   49                   | dec                 ecx
            //   7407                 | je                  9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   3bd3                 | cmp                 edx, ebx
            //   0f858d000000         | jne                 0x93
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]

        $sequence_5 = { e8???????? 83c414 8b55e8 8955f0 c745e400000000 6a10 8d45e4 }
            // n = 7, score = 1200
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   6a10                 | push                0x10
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_6 = { 895e04 40 eb20 8bc3 eb1c e8???????? }
            // n = 6, score = 1200
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   40                   | inc                 eax
            //   eb20                 | jmp                 0x22
            //   8bc3                 | mov                 eax, ebx
            //   eb1c                 | jmp                 0x1e
            //   e8????????           |                     

        $sequence_7 = { 52 8b45fc 50 ff15???????? 83c408 68???????? 8b4dfc }
            // n = 7, score = 1200
            //   52                   | push                edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8
            //   68????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_8 = { 51 8b952cffffff 52 ff15???????? 898558ffffff 8b8560ffffff 898570ffffff }
            // n = 7, score = 1200
            //   51                   | push                ecx
            //   8b952cffffff         | mov                 edx, dword ptr [ebp - 0xd4]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   898558ffffff         | mov                 dword ptr [ebp - 0xa8], eax
            //   8b8560ffffff         | mov                 eax, dword ptr [ebp - 0xa0]
            //   898570ffffff         | mov                 dword ptr [ebp - 0x90], eax

        $sequence_9 = { 6a00 8b55e4 52 ff15???????? 8a45fb 8be5 }
            // n = 6, score = 1200
            //   6a00                 | push                0
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8a45fb               | mov                 al, byte ptr [ebp - 5]
            //   8be5                 | mov                 esp, ebp

    condition:
        7 of them and filesize < 155648
}