rule win_atlantida_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atlantida."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atlantida"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7d8 33d9 03f1 c1f2eb c1b454002000f03f 668b840780fd47a1 0fb68c54002000f0 }
            // n = 7, score = 100
            //   f7d8                 | neg                 eax
            //   33d9                 | xor                 ebx, ecx
            //   03f1                 | add                 esi, ecx
            //   c1f2eb               | sal                 edx, 0xeb
            //   c1b454002000f03f     | sal                 dword ptr [esp + edx*2 - 0xfffe000], 0x3f
            //   668b840780fd47a1     | mov                 ax, word ptr [edi + eax - 0x5eb80280]
            //   0fb68c54002000f0     | movzx               ecx, byte ptr [esp + edx*2 - 0xfffe000]

        $sequence_1 = { e9???????? f7d2 66d1e8 0fca 0f81cb3a0a00 33da 59 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   f7d2                 | not                 edx
            //   66d1e8               | shr                 ax, 1
            //   0fca                 | bswap               edx
            //   0f81cb3a0a00         | jno                 0xa3ad1
            //   33da                 | xor                 ebx, edx
            //   59                   | pop                 ecx

        $sequence_2 = { f6d9 d0c9 80e9b9 fec0 fec0 c1c20c 32d9 }
            // n = 7, score = 100
            //   f6d9                 | neg                 cl
            //   d0c9                 | ror                 cl, 1
            //   80e9b9               | sub                 cl, 0xb9
            //   fec0                 | inc                 al
            //   fec0                 | inc                 al
            //   c1c20c               | rol                 edx, 0xc
            //   32d9                 | xor                 bl, cl

        $sequence_3 = { f7da fec0 f6d0 42 6698 e8???????? 0f34 }
            // n = 7, score = 100
            //   f7da                 | neg                 edx
            //   fec0                 | inc                 al
            //   f6d0                 | not                 al
            //   42                   | inc                 edx
            //   6698                 | cbw                 
            //   e8????????           |                     
            //   0f34                 | sysenter            

        $sequence_4 = { f7d2 66898c8706fefdff 0fbeca 8b144f f6d8 0fabc0 d2c1 }
            // n = 7, score = 100
            //   f7d2                 | not                 edx
            //   66898c8706fefdff     | mov                 word ptr [edi + eax*4 - 0x201fa], cx
            //   0fbeca               | movsx               ecx, dl
            //   8b144f               | mov                 edx, dword ptr [edi + ecx*2]
            //   f6d8                 | neg                 al
            //   0fabc0               | bts                 eax, eax
            //   d2c1                 | rol                 cl, cl

        $sequence_5 = { ffc7 6641 d1c7 6645 0fc1d5 48 99 }
            // n = 7, score = 100
            //   ffc7                 | inc                 edi
            //   6641                 | inc                 cx
            //   d1c7                 | rol                 edi, 1
            //   6645                 | inc                 bp
            //   0fc1d5               | xadd                ebp, edx
            //   48                   | dec                 eax
            //   99                   | cdq                 

        $sequence_6 = { ff5315 14a8 6292bfc572de 1ad7 381d???????? 50 a9dac0aaf7 }
            // n = 7, score = 100
            //   ff5315               | call                dword ptr [ebx + 0x15]
            //   14a8                 | adc                 al, 0xa8
            //   6292bfc572de         | bound               edx, qword ptr [edx - 0x218d3a41]
            //   1ad7                 | sbb                 dl, bh
            //   381d????????         |                     
            //   50                   | push                eax
            //   a9dac0aaf7           | test                eax, 0xf7aac0da

        $sequence_7 = { e8???????? 8b442500 ba90b9872b 80e298 8d0c55ad51af3f 8b8c55e48cf0a8 661bd2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b442500             | mov                 eax, dword ptr [ebp]
            //   ba90b9872b           | mov                 edx, 0x2b87b990
            //   80e298               | and                 dl, 0x98
            //   8d0c55ad51af3f       | lea                 ecx, [edx*2 + 0x3faf51ad]
            //   8b8c55e48cf0a8       | mov                 ecx, dword ptr [ebp + edx*2 - 0x570f731c]
            //   661bd2               | sbb                 dx, dx

        $sequence_8 = { fec0 33d3 6633c9 2d0066b83d 35a05ea552 42 f7da }
            // n = 7, score = 100
            //   fec0                 | inc                 al
            //   33d3                 | xor                 edx, ebx
            //   6633c9               | xor                 cx, cx
            //   2d0066b83d           | sub                 eax, 0x3db86600
            //   35a05ea552           | xor                 eax, 0x52a55ea0
            //   42                   | inc                 edx
            //   f7da                 | neg                 edx

        $sequence_9 = { f7d8 33d8 0fca 66c1f90b 0f878f9f1200 03f0 660fa3d1 }
            // n = 7, score = 100
            //   f7d8                 | neg                 eax
            //   33d8                 | xor                 ebx, eax
            //   0fca                 | bswap               edx
            //   66c1f90b             | sar                 cx, 0xb
            //   0f878f9f1200         | ja                  0x129f95
            //   03f0                 | add                 esi, eax
            //   660fa3d1             | bt                  cx, dx

    condition:
        7 of them and filesize < 13793280
}