rule win_atmii_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atmii."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atmii"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f6c302 740a 83481804 8a0a 884810 }
            // n = 5, score = 100
            //   f6c302               | test                bl, 2
            //   740a                 | je                  0xc
            //   83481804             | or                  dword ptr [eax + 0x18], 4
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   884810               | mov                 byte ptr [eax + 0x10], cl

        $sequence_1 = { eb60 68???????? eb55 68???????? 8d55ac 52 }
            // n = 6, score = 100
            //   eb60                 | jmp                 0x62
            //   68????????           |                     
            //   eb55                 | jmp                 0x57
            //   68????????           |                     
            //   8d55ac               | lea                 edx, [ebp - 0x54]
            //   52                   | push                edx

        $sequence_2 = { 56 c745f800000000 ff15???????? 85c0 0f94c0 8845ff }
            // n = 6, score = 100
            //   56                   | push                esi
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f94c0               | sete                al
            //   8845ff               | mov                 byte ptr [ebp - 1], al

        $sequence_3 = { 8d95dcfbffff 52 e8???????? 83c418 6a00 }
            // n = 5, score = 100
            //   8d95dcfbffff         | lea                 edx, [ebp - 0x424]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   6a00                 | push                0

        $sequence_4 = { 50 ffd3 8a5510 8985cdf9ffff 8b450c 50 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8a5510               | mov                 dl, byte ptr [ebp + 0x10]
            //   8985cdf9ffff         | mov                 dword ptr [ebp - 0x633], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax

        $sequence_5 = { 750a 8b4dfc 8b5109 ffd2 eb02 33c0 }
            // n = 6, score = 100
            //   750a                 | jne                 0xc
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b5109               | mov                 edx, dword ptr [ecx + 9]
            //   ffd2                 | call                edx
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 8b55fc 0355f4 8a02 8801 ebdd 8be5 }
            // n = 6, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0355f4               | add                 edx, dword ptr [ebp - 0xc]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   8801                 | mov                 byte ptr [ecx], al
            //   ebdd                 | jmp                 0xffffffdf
            //   8be5                 | mov                 esp, ebp

        $sequence_7 = { 8d95fcf3ffff 52 e8???????? 83c42c }
            // n = 4, score = 100
            //   8d95fcf3ffff         | lea                 edx, [ebp - 0xc04]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c42c               | add                 esp, 0x2c

        $sequence_8 = { 8d45b8 50 68???????? 68b6000000 8d8df8fcffff 68???????? 51 }
            // n = 7, score = 100
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   68????????           |                     
            //   68b6000000           | push                0xb6
            //   8d8df8fcffff         | lea                 ecx, [ebp - 0x308]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_9 = { 6a00 6a02 ff15???????? 8bf8 897dfc 83ffff 0f8456010000 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   83ffff               | cmp                 edi, -1
            //   0f8456010000         | je                  0x15c

        $sequence_10 = { 8985c5f9ffff ffd7 50 ffd3 }
            // n = 4, score = 100
            //   8985c5f9ffff         | mov                 dword ptr [ebp - 0x63b], eax
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_11 = { 0f8419040000 53 57 6814020000 }
            // n = 4, score = 100
            //   0f8419040000         | je                  0x41f
            //   53                   | push                ebx
            //   57                   | push                edi
            //   6814020000           | push                0x214

        $sequence_12 = { 83c414 68???????? 50 68???????? 68???????? ffd7 8b4e10 }
            // n = 7, score = 100
            //   83c414               | add                 esp, 0x14
            //   68????????           |                     
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]

        $sequence_13 = { 8d45cc 50 eb14 68???????? 8d4dcc }
            // n = 5, score = 100
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   eb14                 | jmp                 0x16
            //   68????????           |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]

        $sequence_14 = { 6a00 ff15???????? 50 ff15???????? 68???????? 68d5000000 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     
            //   68d5000000           | push                0xd5

        $sequence_15 = { 8a8dfcfeffff 8a95fefeffff 8a8500ffffff 57 }
            // n = 4, score = 100
            //   8a8dfcfeffff         | mov                 cl, byte ptr [ebp - 0x104]
            //   8a95fefeffff         | mov                 dl, byte ptr [ebp - 0x102]
            //   8a8500ffffff         | mov                 al, byte ptr [ebp - 0x100]
            //   57                   | push                edi

    condition:
        7 of them and filesize < 49152
}