rule win_atmosphere_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atmosphere."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atmosphere"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a12 50 8b11 ff12 }
            // n = 4, score = 400
            //   6a12                 | push                0x12
            //   50                   | push                eax
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   ff12                 | call                dword ptr [edx]

        $sequence_1 = { c20400 56 57 8b7c240c 8bf1 57 ff15???????? }
            // n = 7, score = 400
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_2 = { 56 f6d8 1bc0 57 83e002 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   f6d8                 | neg                 al
            //   1bc0                 | sbb                 eax, eax
            //   57                   | push                edi
            //   83e002               | and                 eax, 2

        $sequence_3 = { 894114 b001 c20400 8b4114 }
            // n = 4, score = 400
            //   894114               | mov                 dword ptr [ecx + 0x14], eax
            //   b001                 | mov                 al, 1
            //   c20400               | ret                 4
            //   8b4114               | mov                 eax, dword ptr [ecx + 0x14]

        $sequence_4 = { 57 8bce ff502c 84c0 }
            // n = 4, score = 400
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi
            //   ff502c               | call                dword ptr [eax + 0x2c]
            //   84c0                 | test                al, al

        $sequence_5 = { 8b5104 668b0402 8b542404 668902 }
            // n = 4, score = 400
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   668b0402             | mov                 ax, word ptr [edx + eax]
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   668902               | mov                 word ptr [edx], ax

        $sequence_6 = { ff15???????? 56 8bf8 ff15???????? 83c410 8bc7 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   8bc7                 | mov                 eax, edi

        $sequence_7 = { 83ec10 8bc4 89642410 50 }
            // n = 4, score = 400
            //   83ec10               | sub                 esp, 0x10
            //   8bc4                 | mov                 eax, esp
            //   89642410             | mov                 dword ptr [esp + 0x10], esp
            //   50                   | push                eax

        $sequence_8 = { 57 8bf9 6a2e e8???????? }
            // n = 4, score = 400
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   6a2e                 | push                0x2e
            //   e8????????           |                     

        $sequence_9 = { 6a0a 50 8b11 ff12 }
            // n = 4, score = 400
            //   6a0a                 | push                0xa
            //   50                   | push                eax
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   ff12                 | call                dword ptr [edx]

    condition:
        7 of them and filesize < 360448
}