rule win_atmspitter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.atmspitter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.atmspitter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c70009000000 e8???????? ebd1 8bc8 c1f905 8d3c8d60da4000 }
            // n = 6, score = 200
            //   c70009000000         | mov                 dword ptr [eax], 9
            //   e8????????           |                     
            //   ebd1                 | jmp                 0xffffffd3
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8d3c8d60da4000       | lea                 edi, [ecx*4 + 0x40da60]

        $sequence_1 = { 57 8bc2 c1f805 8b048560da4000 8bfa }
            // n = 5, score = 200
            //   57                   | push                edi
            //   8bc2                 | mov                 eax, edx
            //   c1f805               | sar                 eax, 5
            //   8b048560da4000       | mov                 eax, dword ptr [eax*4 + 0x40da60]
            //   8bfa                 | mov                 edi, edx

        $sequence_2 = { c686c800000043 c6864b01000043 c7466850c44000 6a0d e8???????? 59 8365fc00 }
            // n = 7, score = 200
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466850c44000       | mov                 dword ptr [esi + 0x68], 0x40c450
            //   6a0d                 | push                0xd
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0

        $sequence_3 = { ff15???????? 6a02 6a00 8bf8 6a00 57 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   8bf8                 | mov                 edi, eax
            //   6a00                 | push                0
            //   57                   | push                edi

        $sequence_4 = { 7d0d 8a4c181c 888870c64000 40 }
            // n = 4, score = 200
            //   7d0d                 | jge                 0xf
            //   8a4c181c             | mov                 cl, byte ptr [eax + ebx + 0x1c]
            //   888870c64000         | mov                 byte ptr [eax + 0x40c670], cl
            //   40                   | inc                 eax

        $sequence_5 = { 50 68???????? e8???????? 83c408 68???????? e8???????? 8b4528 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   68????????           |                     
            //   e8????????           |                     
            //   8b4528               | mov                 eax, dword ptr [ebp + 0x28]

        $sequence_6 = { 83f914 0f8798000000 0fb691b0854000 ff249588854000 }
            // n = 4, score = 200
            //   83f914               | cmp                 ecx, 0x14
            //   0f8798000000         | ja                  0x9e
            //   0fb691b0854000       | movzx               edx, byte ptr [ecx + 0x4085b0]
            //   ff249588854000       | jmp                 dword ptr [edx*4 + 0x408588]

        $sequence_7 = { 0f8c260a0000 8d42e0 3c58 770f 0fbec2 0fbe8060914000 83e00f }
            // n = 7, score = 200
            //   0f8c260a0000         | jl                  0xa2c
            //   8d42e0               | lea                 eax, [edx - 0x20]
            //   3c58                 | cmp                 al, 0x58
            //   770f                 | ja                  0x11
            //   0fbec2               | movsx               eax, dl
            //   0fbe8060914000       | movsx               eax, byte ptr [eax + 0x409160]
            //   83e00f               | and                 eax, 0xf

        $sequence_8 = { 56 57 50 c745fc00000000 ffd3 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   50                   | push                eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   ffd3                 | call                ebx

        $sequence_9 = { 53 8b1d???????? 56 57 50 c745fc00000000 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   8b1d????????         |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   50                   | push                eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

    condition:
        7 of them and filesize < 147456
}