rule win_attor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.attor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.attor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f801 7411 3d81000000 740a }
            // n = 4, score = 400
            //   83f801               | cmp                 eax, 1
            //   7411                 | je                  0x13
            //   3d81000000           | cmp                 eax, 0x81
            //   740a                 | je                  0xc

        $sequence_1 = { 488bea 4c8be1 4889742440 4885c9 }
            // n = 4, score = 300
            //   488bea               | mov                 ebp, dword ptr [esp + 0x48]
            //   4c8be1               | dec                 ebp
            //   4889742440           | test                esp, esp
            //   4885c9               | dec                 eax

        $sequence_2 = { 0f84aa000000 4885d2 0f84a1000000 48895c2448 488d5a08 }
            // n = 5, score = 300
            //   0f84aa000000         | je                  0xb0
            //   4885d2               | dec                 eax
            //   0f84a1000000         | test                edx, edx
            //   48895c2448           | je                  0xa7
            //   488d5a08             | dec                 eax

        $sequence_3 = { 498bcd e8???????? 4c8b6c2448 4d85e4 }
            // n = 4, score = 300
            //   498bcd               | mov                 dword ptr [esp + 0x48], ebx
            //   e8????????           |                     
            //   4c8b6c2448           | dec                 eax
            //   4d85e4               | lea                 ebx, [edx + 8]

        $sequence_4 = { 48896810 488970e0 488978d8 33db 4c8970d0 4532e4 33f6 }
            // n = 7, score = 300
            //   48896810             | mov                 dword ptr [esp + 0x30], eax
            //   488970e0             | dec                 eax
            //   488978d8             | cmp                 dword ptr [esp + 0x80], ebx
            //   33db                 | je                  0xf5
            //   4c8970d0             | dec                 eax
            //   4532e4               | mov                 ebp, edx
            //   33f6                 | dec                 esp

        $sequence_5 = { 4885c9 7427 488b842490000000 48899c2490000000 }
            // n = 4, score = 300
            //   4885c9               | test                ecx, ecx
            //   7427                 | dec                 eax
            //   488b842490000000     | mov                 dword ptr [eax + 0x10], ebp
            //   48899c2490000000     | dec                 eax

        $sequence_6 = { 4889442430 e8???????? 48399c2480000000 0f84ef000000 }
            // n = 4, score = 300
            //   4889442430           | dec                 ecx
            //   e8????????           |                     
            //   48399c2480000000     | mov                 ecx, ebp
            //   0f84ef000000         | dec                 esp

        $sequence_7 = { 4c8b6c2448 4d85e4 740f 33c9 e8???????? }
            // n = 5, score = 300
            //   4c8b6c2448           | mov                 esp, ecx
            //   4d85e4               | dec                 eax
            //   740f                 | mov                 dword ptr [esp + 0x40], esi
            //   33c9                 | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 83c404 83e103 f3aa 8b442414 85c0 }
            // n = 5, score = 200
            //   83c404               | mov                 eax, dword ptr [esp + 0x90]
            //   83e103               | dec                 eax
            //   f3aa                 | mov                 dword ptr [esp + 0x90], ebx
            //   8b442414             | dec                 esp
            //   85c0                 | mov                 esp, ecx

        $sequence_9 = { 8bcf 8b7c2414 8bd1 33c0 c1e902 }
            // n = 5, score = 200
            //   8bcf                 | dec                 eax
            //   8b7c2414             | mov                 dword ptr [edi], eax
            //   8bd1                 | dec                 eax
            //   33c0                 | mov                 dword ptr [edi + 8], eax
            //   c1e902               | je                  0xc

        $sequence_10 = { 740a 83f808 7405 83f811 }
            // n = 4, score = 200
            //   740a                 | mov                 ebp, dword ptr [esp + 0x48]
            //   83f808               | dec                 ebp
            //   7405                 | test                esp, esp
            //   83f811               | je                  0x11

        $sequence_11 = { 33ff 3bf7 c644241300 897c2418 897c241c 897c2414 0f8423010000 }
            // n = 7, score = 200
            //   33ff                 | lea                 eax, [esp + 0x14]
            //   3bf7                 | lea                 ecx, [esp + 0x20]
            //   c644241300           | push                eax
            //   897c2418             | push                ecx
            //   897c241c             | add                 esp, 4
            //   897c2414             | and                 ecx, 3
            //   0f8423010000         | rep stosb           byte ptr es:[edi], al

        $sequence_12 = { ff15???????? 89442420 8d442414 8d4c2420 50 51 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   89442420             | xor                 ecx, ecx
            //   8d442414             | dec                 eax
            //   8d4c2420             | test                ecx, ecx
            //   50                   | je                  0x2c
            //   51                   | dec                 eax

        $sequence_13 = { 7411 6a00 e8???????? 56 ff15???????? 83c408 8b442430 }
            // n = 7, score = 200
            //   7411                 | dec                 eax
            //   6a00                 | mov                 dword ptr [esp + 0x40], esi
            //   e8????????           |                     
            //   56                   | dec                 eax
            //   ff15????????         |                     
            //   83c408               | test                ecx, ecx
            //   8b442430             | je                  0xb8

        $sequence_14 = { 57 ffd6 83c408 8b7c2428 85ff 740d }
            // n = 6, score = 200
            //   57                   | inc                 eax
            //   ffd6                 | xor                 ch, ch
            //   83c408               | mov                 ebx, eax
            //   8b7c2428             | xor                 eax, eax
            //   85ff                 | dec                 eax
            //   740d                 | mov                 ecx, edi

        $sequence_15 = { e8???????? 83c40c 3bc7 8944241c 0f84f3000000 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c40c               | cmp                 eax, 8
            //   3bc7                 | je                  0xa
            //   8944241c             | cmp                 eax, 0x11
            //   0f84f3000000         | mov                 dword ptr [esp + 0x20], eax

    condition:
        7 of them and filesize < 2023424
}