rule win_avaddon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.avaddon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avaddon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7459408020000 837f1410 c7459810660000 c7459c20000000 7202 8b3f 0f1007 }
            // n = 7, score = 200
            //   c7459408020000       | mov                 dword ptr [ebp - 0x6c], 0x208
            //   837f1410             | cmp                 dword ptr [edi + 0x14], 0x10
            //   c7459810660000       | mov                 dword ptr [ebp - 0x68], 0x6610
            //   c7459c20000000       | mov                 dword ptr [ebp - 0x64], 0x20
            //   7202                 | jb                  4
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   0f1007               | movups              xmm0, xmmword ptr [edi]

        $sequence_1 = { bf20000000 0f1f00 84db 7574 ff75fc 57 ff75f8 }
            // n = 7, score = 200
            //   bf20000000           | mov                 edi, 0x20
            //   0f1f00               | nop                 dword ptr [eax]
            //   84db                 | test                bl, bl
            //   7574                 | jne                 0x76
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   57                   | push                edi
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_2 = { 0f4345d0 51 50 8d45e8 50 ff15???????? 837de410 }
            // n = 7, score = 200
            //   0f4345d0             | cmovae              eax, dword ptr [ebp - 0x30]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   837de410             | cmp                 dword ptr [ebp - 0x1c], 0x10

        $sequence_3 = { 83c404 3dff000000 7607 b8ff000000 eb09 83c0ff 0f886f000000 }
            // n = 7, score = 200
            //   83c404               | add                 esp, 4
            //   3dff000000           | cmp                 eax, 0xff
            //   7607                 | jbe                 9
            //   b8ff000000           | mov                 eax, 0xff
            //   eb09                 | jmp                 0xb
            //   83c0ff               | add                 eax, -1
            //   0f886f000000         | js                  0x75

        $sequence_4 = { 8b4dcc 8b45d0 030e 83c018 8b75d4 8b55c0 46 }
            // n = 7, score = 200
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   030e                 | add                 ecx, dword ptr [esi]
            //   83c018               | add                 eax, 0x18
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]
            //   8b55c0               | mov                 edx, dword ptr [ebp - 0x40]
            //   46                   | inc                 esi

        $sequence_5 = { 0bc8 51 e8???????? 8bcf 83c404 47 8bf0 }
            // n = 7, score = 200
            //   0bc8                 | or                  ecx, eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8bcf                 | mov                 ecx, edi
            //   83c404               | add                 esp, 4
            //   47                   | inc                 edi
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { 8b4e08 b8ffffff07 2bca 47 c1f905 8bd1 d1ea }
            // n = 7, score = 200
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   b8ffffff07           | mov                 eax, 0x7ffffff
            //   2bca                 | sub                 ecx, edx
            //   47                   | inc                 edi
            //   c1f905               | sar                 ecx, 5
            //   8bd1                 | mov                 edx, ecx
            //   d1ea                 | shr                 edx, 1

        $sequence_7 = { c78524fdffff00000000 c78528fdffff0f000000 c68514fdffff00 898d2cfdffff 8a08 40 84c9 }
            // n = 7, score = 200
            //   c78524fdffff00000000     | mov    dword ptr [ebp - 0x2dc], 0
            //   c78528fdffff0f000000     | mov    dword ptr [ebp - 0x2d8], 0xf
            //   c68514fdffff00       | mov                 byte ptr [ebp - 0x2ec], 0
            //   898d2cfdffff         | mov                 dword ptr [ebp - 0x2d4], ecx
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl

        $sequence_8 = { 51 8b4df0 e8???????? 83c410 83f8ff 750e 8d4510 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   83f8ff               | cmp                 eax, -1
            //   750e                 | jne                 0x10
            //   8d4510               | lea                 eax, [ebp + 0x10]

        $sequence_9 = { e8???????? 83c408 33c0 c745ac00000000 6689459c 8b45e8 c745b007000000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   33c0                 | xor                 eax, eax
            //   c745ac00000000       | mov                 dword ptr [ebp - 0x54], 0
            //   6689459c             | mov                 word ptr [ebp - 0x64], ax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   c745b007000000       | mov                 dword ptr [ebp - 0x50], 7

    condition:
        7 of them and filesize < 2343936
}