rule win_avos_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.avos_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.avos_locker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8d80fbffff e8???????? 888595fbffff 6a20 8d8d80fbffff e8???????? 888596fbffff }
            // n = 7, score = 100
            //   8d8d80fbffff         | lea                 ecx, [ebp - 0x480]
            //   e8????????           |                     
            //   888595fbffff         | mov                 byte ptr [ebp - 0x46b], al
            //   6a20                 | push                0x20
            //   8d8d80fbffff         | lea                 ecx, [ebp - 0x480]
            //   e8????????           |                     
            //   888596fbffff         | mov                 byte ptr [ebp - 0x46a], al

        $sequence_1 = { 83fe1a 7ce4 eb0c 57 8d44241c 50 ff15???????? }
            // n = 7, score = 100
            //   83fe1a               | cmp                 esi, 0x1a
            //   7ce4                 | jl                  0xffffffe6
            //   eb0c                 | jmp                 0xe
            //   57                   | push                edi
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_2 = { c7462800000000 c7462c00000000 0f114618 c645c000 f30f7e45d0 660fd64628 c745d000000000 }
            // n = 7, score = 100
            //   c7462800000000       | mov                 dword ptr [esi + 0x28], 0
            //   c7462c00000000       | mov                 dword ptr [esi + 0x2c], 0
            //   0f114618             | movups              xmmword ptr [esi + 0x18], xmm0
            //   c645c000             | mov                 byte ptr [ebp - 0x40], 0
            //   f30f7e45d0           | movq                xmm0, qword ptr [ebp - 0x30]
            //   660fd64628           | movq                qword ptr [esi + 0x28], xmm0
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0

        $sequence_3 = { 64a300000000 8bf1 8975ec c745fc00000000 6a24 c745f000000000 e8???????? }
            // n = 7, score = 100
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf1                 | mov                 esi, ecx
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   6a24                 | push                0x24
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   e8????????           |                     

        $sequence_4 = { 8955ec 3bda 7467 8b4208 8b4b08 8b730c }
            // n = 6, score = 100
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   3bda                 | cmp                 ebx, edx
            //   7467                 | je                  0x69
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   8b4b08               | mov                 ecx, dword ptr [ebx + 8]
            //   8b730c               | mov                 esi, dword ptr [ebx + 0xc]

        $sequence_5 = { 8d46ec 6a00 50 ff15???????? 85c0 0f8506080000 8b4604 }
            // n = 7, score = 100
            //   8d46ec               | lea                 eax, [esi - 0x14]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8506080000         | jne                 0x80c
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_6 = { 50 e8???????? 83c40c 6b45e430 8945e0 8d8090f74b00 8945e4 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6b45e430             | imul                eax, dword ptr [ebp - 0x1c], 0x30
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d8090f74b00         | lea                 eax, [eax + 0x4bf790]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax

        $sequence_7 = { 66890451 33c0 6689445102 59 c20400 ff742408 c644240400 }
            // n = 7, score = 100
            //   66890451             | mov                 word ptr [ecx + edx*2], ax
            //   33c0                 | xor                 eax, eax
            //   6689445102           | mov                 word ptr [ecx + edx*2 + 2], ax
            //   59                   | pop                 ecx
            //   c20400               | ret                 4
            //   ff742408             | push                dword ptr [esp + 8]
            //   c644240400           | mov                 byte ptr [esp + 4], 0

        $sequence_8 = { 8bcc 89a54cf7ffff 68???????? e8???????? c645fc35 8d85b8f9ffff 50 }
            // n = 7, score = 100
            //   8bcc                 | mov                 ecx, esp
            //   89a54cf7ffff         | mov                 dword ptr [ebp - 0x8b4], esp
            //   68????????           |                     
            //   e8????????           |                     
            //   c645fc35             | mov                 byte ptr [ebp - 4], 0x35
            //   8d85b8f9ffff         | lea                 eax, [ebp - 0x648]
            //   50                   | push                eax

        $sequence_9 = { 8b11 8d4201 8901 8a442413 8802 0fb6c0 eb0b }
            // n = 7, score = 100
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8d4201               | lea                 eax, [edx + 1]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8a442413             | mov                 al, byte ptr [esp + 0x13]
            //   8802                 | mov                 byte ptr [edx], al
            //   0fb6c0               | movzx               eax, al
            //   eb0b                 | jmp                 0xd

    condition:
        7 of them and filesize < 1701888
}