rule win_ayegent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ayegent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ayegent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? 8d542400 52 50 ff15???????? 8b4c2428 8b542424 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   8d542400             | lea                 edx, [esp]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]

        $sequence_1 = { 51 6804010000 aa e8???????? 83c408 ffd5 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   6804010000           | push                0x104
            //   aa                   | stosb               byte ptr es:[edi], al
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   ffd5                 | call                ebp

        $sequence_2 = { 885c2420 f3ab 66ab 8d4c2420 51 6804010000 aa }
            // n = 7, score = 100
            //   885c2420             | mov                 byte ptr [esp + 0x20], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   51                   | push                ecx
            //   6804010000           | push                0x104
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_3 = { 770e 8088????????20 8ac8 80e920 ebe0 80a0609d400000 40 }
            // n = 7, score = 100
            //   770e                 | ja                  0x10
            //   8088????????20       |                     
            //   8ac8                 | mov                 cl, al
            //   80e920               | sub                 cl, 0x20
            //   ebe0                 | jmp                 0xffffffe2
            //   80a0609d400000       | and                 byte ptr [eax + 0x409d60], 0
            //   40                   | inc                 eax

        $sequence_4 = { ff15???????? 8d542420 50 52 8d442428 68???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   50                   | push                eax
            //   52                   | push                edx
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   68????????           |                     

        $sequence_5 = { 8d7c2421 885c2420 f3ab 66ab 8d4c2420 51 }
            // n = 6, score = 100
            //   8d7c2421             | lea                 edi, [esp + 0x21]
            //   885c2420             | mov                 byte ptr [esp + 0x20], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   51                   | push                ecx

        $sequence_6 = { 6808020000 50 53 68???????? 68???????? 885c2428 ffd5 }
            // n = 7, score = 100
            //   6808020000           | push                0x208
            //   50                   | push                eax
            //   53                   | push                ebx
            //   68????????           |                     
            //   68????????           |                     
            //   885c2428             | mov                 byte ptr [esp + 0x28], bl
            //   ffd5                 | call                ebp

        $sequence_7 = { 66ab aa 8d442408 56 50 }
            // n = 5, score = 100
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d442408             | lea                 eax, [esp + 8]
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_8 = { 53 68???????? 8d4c2428 68???????? 51 68???????? }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   68????????           |                     
            //   8d4c2428             | lea                 ecx, [esp + 0x28]
            //   68????????           |                     
            //   51                   | push                ecx
            //   68????????           |                     

        $sequence_9 = { 66ab aa 8d442420 50 6a00 e8???????? }
            // n = 6, score = 100
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   e8????????           |                     

    condition:
        7 of them and filesize < 90112
}