rule win_aytoke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.aytoke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.aytoke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b450c 8b4d10 56 57 8b7d08 8d95dcfbffff }
            // n = 6, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8d95dcfbffff         | lea                 edx, [ebp - 0x424]

        $sequence_1 = { a1???????? 8b0d???????? 8b15???????? 8985a8f9ffff }
            // n = 4, score = 200
            //   a1????????           |                     
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   8985a8f9ffff         | mov                 dword ptr [ebp - 0x658], eax

        $sequence_2 = { ffd2 8b8594f9ffff 50 ff15???????? }
            // n = 4, score = 200
            //   ffd2                 | call                edx
            //   8b8594f9ffff         | mov                 eax, dword ptr [ebp - 0x66c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { 4d 4d 0b0c0d0e0f1011 1213 1415 }
            // n = 5, score = 200
            //   4d                   | dec                 ebp
            //   4d                   | dec                 ebp
            //   0b0c0d0e0f1011       | or                  ecx, dword ptr [ecx + 0x11100f0e]
            //   1213                 | adc                 dl, byte ptr [ebx]
            //   1415                 | adc                 al, 0x15

        $sequence_4 = { 7407 c6854feeffff01 6a14 ff15???????? 6890000000 ffd3 }
            // n = 6, score = 200
            //   7407                 | je                  9
            //   c6854feeffff01       | mov                 byte ptr [ebp - 0x11b1], 1
            //   6a14                 | push                0x14
            //   ff15????????         |                     
            //   6890000000           | push                0x90
            //   ffd3                 | call                ebx

        $sequence_5 = { 83c414 8d45c8 48 8a4801 40 }
            // n = 5, score = 200
            //   83c414               | add                 esp, 0x14
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   48                   | dec                 eax
            //   8a4801               | mov                 cl, byte ptr [eax + 1]
            //   40                   | inc                 eax

        $sequence_6 = { 881438 46 47 ebd7 8b8dd8fbffff }
            // n = 5, score = 200
            //   881438               | mov                 byte ptr [eax + edi], dl
            //   46                   | inc                 esi
            //   47                   | inc                 edi
            //   ebd7                 | jmp                 0xffffffd9
            //   8b8dd8fbffff         | mov                 ecx, dword ptr [ebp - 0x428]

        $sequence_7 = { 8d55ec 52 b902000000 56 8945f0 66894dec ff15???????? }
            // n = 7, score = 200
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   52                   | push                edx
            //   b902000000           | mov                 ecx, 2
            //   56                   | push                esi
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   66894dec             | mov                 word ptr [ebp - 0x14], cx
            //   ff15????????         |                     

        $sequence_8 = { 4d 4d 0b0c0d0e0f1011 1213 1415 16 17 }
            // n = 7, score = 200
            //   4d                   | dec                 ebp
            //   4d                   | dec                 ebp
            //   0b0c0d0e0f1011       | or                  ecx, dword ptr [ecx + 0x11100f0e]
            //   1213                 | adc                 dl, byte ptr [ebx]
            //   1415                 | adc                 al, 0x15
            //   16                   | push                ss
            //   17                   | pop                 ss

        $sequence_9 = { 8bc6 c1f805 8b048500c44100 83e61f c1e606 8d443004 }
            // n = 6, score = 200
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8b048500c44100       | mov                 eax, dword ptr [eax*4 + 0x41c400]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   8d443004             | lea                 eax, [eax + esi + 4]

    condition:
        7 of them and filesize < 425984
}