rule win_azov_wiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.azov_wiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.azov_wiper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883ef01 75e6 488b05???????? 33c9 488b10 }
            // n = 5, score = 100
            //   4883ef01             | mov                 ecx, ebx
            //   75e6                 | dec                 eax
            //   488b05????????       |                     
            //   33c9                 | mov                 edx, dword ptr [eax]
            //   488b10               | jne                 0x21f

        $sequence_1 = { 741e 488b05???????? bafe010000 488bcb 4c8b00 }
            // n = 5, score = 100
            //   741e                 | movzx               eax, word ptr [ecx]
            //   488b05????????       |                     
            //   bafe010000           | mov                 word ptr [edx + ecx], ax
            //   488bcb               | dec                 eax
            //   4c8b00               | lea                 ecx, [ecx + 2]

        $sequence_2 = { 4889442420 41ff9258010000 488b8c2470080000 4885c9 7410 488b05???????? }
            // n = 6, score = 100
            //   4889442420           | call                dword ptr [eax + 0x38]
            //   41ff9258010000       | dec                 eax
            //   488b8c2470080000     | mov                 esi, ecx
            //   4885c9               | dec                 ecx
            //   7410                 | mov                 dword ptr [ebx - 0x38], eax
            //   488b05????????       |                     

        $sequence_3 = { 4c8b10 4883c8ff 0f1f00 66837c410200 488d4001 75f4 }
            // n = 6, score = 100
            //   4c8b10               | mov                 ecx, 0x15c13
            //   4883c8ff             | inc                 ecx
            //   0f1f00               | mov                 edx, 0x92819200
            //   66837c410200         | dec                 eax
            //   488d4001             | dec                 ecx
            //   75f4                 | jne                 0x46a

        $sequence_4 = { 488d55f3 ffd0 4883ec08 48c7042400000000 }
            // n = 4, score = 100
            //   488d55f3             | dec                 eax
            //   ffd0                 | mov                 dword ptr [esp + 0x20], edi
            //   4883ec08             | dec                 eax
            //   48c7042400000000     | mov                 dword ptr [esp + 0x28], edi

        $sequence_5 = { 488b0b 488b10 ff5250 488d5b08 4883ef01 75e6 488b05???????? }
            // n = 7, score = 100
            //   488b0b               | dec                 eax
            //   488b10               | mov                 dword ptr [esp + 0x28], edi
            //   ff5250               | inc                 esp
            //   488d5b08             | mov                 eax, ebp
            //   4883ef01             | mov                 edx, 0xc0000000
            //   75e6                 | dec                 eax
            //   488b05????????       |                     

        $sequence_6 = { 488bce 4c8b10 41ff5240 4885c0 }
            // n = 4, score = 100
            //   488bce               | cmp                 eax, 0x29a
            //   4c8b10               | je                  0x253
            //   41ff5240             | dec                 eax
            //   4885c0               | mov                 dword ptr [esp], esi

        $sequence_7 = { 498943e0 488d055cfbffff 498943e8 488b05???????? 488bce }
            // n = 5, score = 100
            //   498943e0             | dec                 esp
            //   488d055cfbffff       | mov                 edx, dword ptr [eax]
            //   498943e8             | inc                 ecx
            //   488b05????????       |                     
            //   488bce               | mov                 ecx, 0x5000

        $sequence_8 = { 488b3d???????? f20f10842460020000 488b4710 f20f5c4004 660f2f400c 7310 }
            // n = 6, score = 100
            //   488b3d????????       |                     
            //   f20f10842460020000     | sub    esp, 0x20
            //   488b4710             | dec                 eax
            //   f20f5c4004           | and                 esp, 0xfffffff0
            //   660f2f400c           | dec                 esp
            //   7310                 | mov                 dword ptr [esp + 0x80], esi

        $sequence_9 = { 488b05???????? 498d8f00040000 48895c2430 4533c9 }
            // n = 4, score = 100
            //   488b05????????       |                     
            //   498d8f00040000       | or                  ebx, 0xffffffff
            //   48895c2430           | dec                 eax
            //   4533c9               | mov                 eax, ebx

    condition:
        7 of them and filesize < 73728
}