rule win_bachosens_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bachosens."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bachosens"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4d8bd4 4d2bdc 4d8bc4 49f7da }
            // n = 4, score = 200
            //   4d8bd4               | add                 edx, 0x514
            //   4d2bdc               | dec                 eax
            //   4d8bc4               | mov                 ecx, esi
            //   49f7da               | dec                 eax

        $sequence_1 = { 488bf9 488b5018 488b5a20 488bd1 488b4b50 e8???????? }
            // n = 6, score = 200
            //   488bf9               | inc                 eax
            //   488b5018             | mov                 dword ptr [esp + 0x20], eax
            //   488b5a20             | dec                 eax
            //   488bd1               | arpl                word ptr [esp + 0x20], ax
            //   488b4b50             | mov                 byte ptr [esp + eax + 0x190], 0x66
            //   e8????????           |                     

        $sequence_2 = { 49f7da 6666660f1f840000000000 430fb61403 410fb608 }
            // n = 4, score = 200
            //   49f7da               | dec                 eax
            //   6666660f1f840000000000     | test    esi, esi
            //   430fb61403           | je                  0x643
            //   410fb608             | dec                 eax

        $sequence_3 = { 740e 488bc7 ffc1 488d4001 803800 }
            // n = 5, score = 200
            //   740e                 | dec                 eax
            //   488bc7               | mov                 dword ptr [esp + 0x48], eax
            //   ffc1                 | dec                 eax
            //   488d4001             | mov                 dword ptr [esp + 0x50], eax
            //   803800               | dec                 eax

        $sequence_4 = { 33d2 385500 740e 488bc5 ffc2 }
            // n = 5, score = 200
            //   33d2                 | test                eax, eax
            //   385500               | je                  0x18da
            //   740e                 | dec                 eax
            //   488bc5               | lea                 ecx, [0x12aa4]
            //   ffc2                 | dec                 eax

        $sequence_5 = { 660f1f840000000000 420fb61407 410fb608 8d429f }
            // n = 4, score = 200
            //   660f1f840000000000     | dec    eax
            //   420fb61407           | mov                 ecx, edi
            //   410fb608             | dec                 eax
            //   8d429f               | mov                 edx, esi

        $sequence_6 = { 41380a 7417 498bc2 660f1f840000000000 ffc1 }
            // n = 5, score = 200
            //   41380a               | mov                 ecx, dword ptr [edi + 0x38]
            //   7417                 | mov                 dword ptr [ecx + 3], eax
            //   498bc2               | dec                 eax
            //   660f1f840000000000     | mov    ecx, dword ptr [edi + 0x38]
            //   ffc1                 | mov                 eax, dword ptr [edi + 0x10]

        $sequence_7 = { 66390a 7417 488bc2 0f1f840000000000 ffc1 488d4002 }
            // n = 6, score = 200
            //   66390a               | mov                 ecx, 0x10
            //   7417                 | dec                 eax
            //   488bc2               | mov                 edx, dword ptr [ebp + 0x40]
            //   0f1f840000000000     | dec                 eax
            //   ffc1                 | mov                 ecx, eax
            //   488d4002             | inc                 ecx

        $sequence_8 = { 430fb61403 410fb608 8d429f 3c19 }
            // n = 4, score = 200
            //   430fb61403           | mov                 ebp, dword ptr [esp + 0x30]
            //   410fb608             | inc                 ebp
            //   8d429f               | cmp                 ebp, dword ptr [esp + 5]
            //   3c19                 | inc                 ecx

        $sequence_9 = { 803800 75f5 3bca 7550 4c63d1 85c9 7e42 }
            // n = 7, score = 200
            //   803800               | div                 ecx
            //   75f5                 | je                  0x2b0
            //   3bca                 | dec                 eax
            //   7550                 | arpl                word ptr [ecx + 0x3d0], cx
            //   4c63d1               | xor                 edx, edx
            //   85c9                 | dec                 ecx
            //   7e42                 | mov                 eax, ecx

    condition:
        7 of them and filesize < 643072
}