rule win_backbend_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.backbend."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.backbend"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c40c 8d45f0 c745d801000000 66c745dc0500 50 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   c745d801000000       | mov                 dword ptr [ebp - 0x28], 1
            //   66c745dc0500         | mov                 word ptr [ebp - 0x24], 5
            //   50                   | push                eax

        $sequence_1 = { 56 ffd3 6a00 8d8500ffffff }
            // n = 4, score = 100
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   6a00                 | push                0
            //   8d8500ffffff         | lea                 eax, [ebp - 0x100]

        $sequence_2 = { c3 8b442404 8a08 84c9 7408 80e904 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   84c9                 | test                cl, cl
            //   7408                 | je                  0xa
            //   80e904               | sub                 cl, 4

        $sequence_3 = { ebf2 c3 55 8bec 81ec0c010000 }
            // n = 5, score = 100
            //   ebf2                 | jmp                 0xfffffff4
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec0c010000         | sub                 esp, 0x10c

        $sequence_4 = { 6860ea0000 ffd6 33c0 8d8d00feffff 50 }
            // n = 5, score = 100
            //   6860ea0000           | push                0xea60
            //   ffd6                 | call                esi
            //   33c0                 | xor                 eax, eax
            //   8d8d00feffff         | lea                 ecx, [ebp - 0x200]
            //   50                   | push                eax

        $sequence_5 = { 50 e8???????? 8d8500fbffff 53 50 e8???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8500fbffff         | lea                 eax, [ebp - 0x500]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { c605????????43 ff15???????? 8bf0 68???????? }
            // n = 4, score = 100
            //   c605????????43       |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   68????????           |                     

        $sequence_7 = { 85c0 7508 6a01 58 e9???????? 6a07 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   6a01                 | push                1
            //   58                   | pop                 eax
            //   e9????????           |                     
            //   6a07                 | push                7

        $sequence_8 = { 57 ffd6 85c0 740b 50 ff15???????? }
            // n = 6, score = 100
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   740b                 | je                  0xd
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { c745d801000000 66c745dc0500 50 8d45ac 50 53 }
            // n = 6, score = 100
            //   c745d801000000       | mov                 dword ptr [ebp - 0x28], 1
            //   66c745dc0500         | mov                 word ptr [ebp - 0x24], 5
            //   50                   | push                eax
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   50                   | push                eax
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 49152
}