rule win_backswap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.backswap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.backswap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 e9???????? b32a 397d14 7412 47 8a07 }
            // n = 7, score = 400
            //   33c9                 | xor                 ecx, ecx
            //   e9????????           |                     
            //   b32a                 | mov                 bl, 0x2a
            //   397d14               | cmp                 dword ptr [ebp + 0x14], edi
            //   7412                 | je                  0x14
            //   47                   | inc                 edi
            //   8a07                 | mov                 al, byte ptr [edi]

        $sequence_1 = { f366a5 59 5f 5e c9 c20c00 55 }
            // n = 7, score = 400
            //   f366a5               | rep movsw           word ptr es:[edi], word ptr [esi]
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp

        $sequence_2 = { eb04 8bc6 91 41 5e 5f }
            // n = 6, score = 400
            //   eb04                 | jmp                 6
            //   8bc6                 | mov                 eax, esi
            //   91                   | xchg                eax, ecx
            //   41                   | inc                 ecx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi

        $sequence_3 = { 74c4 3c2a 7508 8bdf 897508 4e ebb8 }
            // n = 7, score = 400
            //   74c4                 | je                  0xffffffc6
            //   3c2a                 | cmp                 al, 0x2a
            //   7508                 | jne                 0xa
            //   8bdf                 | mov                 ebx, edi
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   4e                   | dec                 esi
            //   ebb8                 | jmp                 0xffffffba

        $sequence_4 = { 33d2 8bdf 4b eb1c 85c9 7508 3bdf }
            // n = 7, score = 400
            //   33d2                 | xor                 edx, edx
            //   8bdf                 | mov                 ebx, edi
            //   4b                   | dec                 ebx
            //   eb1c                 | jmp                 0x1e
            //   85c9                 | test                ecx, ecx
            //   7508                 | jne                 0xa
            //   3bdf                 | cmp                 ebx, edi

        $sequence_5 = { 7482 8b7508 ff4508 8bfb 3bd3 0f8572ffffff 33c9 }
            // n = 7, score = 400
            //   7482                 | je                  0xffffff84
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   ff4508               | inc                 dword ptr [ebp + 8]
            //   8bfb                 | mov                 edi, ebx
            //   3bd3                 | cmp                 edx, ebx
            //   0f8572ffffff         | jne                 0xffffff78
            //   33c9                 | xor                 ecx, ecx

        $sequence_6 = { 7404 8bce 8bd3 397d14 0f8e99000000 39750c 7e7b }
            // n = 7, score = 400
            //   7404                 | je                  6
            //   8bce                 | mov                 ecx, esi
            //   8bd3                 | mov                 edx, ebx
            //   397d14               | cmp                 dword ptr [ebp + 0x14], edi
            //   0f8e99000000         | jle                 0x9f
            //   39750c               | cmp                 dword ptr [ebp + 0xc], esi
            //   7e7b                 | jle                 0x7d

        $sequence_7 = { d1e9 f366a5 59 5f 5e }
            // n = 5, score = 400
            //   d1e9                 | shr                 ecx, 1
            //   f366a5               | rep movsw           word ptr es:[edi], word ptr [esi]
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { e8???????? 74ed 33c0 eb04 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   74ed                 | je                  0xffffffef
            //   33c0                 | xor                 eax, eax
            //   eb04                 | jmp                 6

        $sequence_9 = { 33c9 e9???????? b32a 397d14 }
            // n = 4, score = 400
            //   33c9                 | xor                 ecx, ecx
            //   e9????????           |                     
            //   b32a                 | mov                 bl, 0x2a
            //   397d14               | cmp                 dword ptr [ebp + 0x14], edi

    condition:
        7 of them and filesize < 122880
}