rule win_badaudio_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.badaudio."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badaudio"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 886e09 88560d 886602 884e0a }
            // n = 4, score = 300
            //   886e09               | mov                 byte ptr [esi + 9], ch
            //   88560d               | mov                 byte ptr [esi + 0xd], dl
            //   886602               | mov                 byte ptr [esi + 2], ah
            //   884e0a               | mov                 byte ptr [esi + 0xa], cl

        $sequence_1 = { c6470c00 807de000 0f8447ffffff 8b45dc c745dc00000000 8b4dd4 }
            // n = 6, score = 300
            //   c6470c00             | mov                 byte ptr [edi + 0xc], 0
            //   807de000             | cmp                 byte ptr [ebp - 0x20], 0
            //   0f8447ffffff         | je                  0xffffff4d
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]

        $sequence_2 = { 885c8103 40 83f83c 7463 8a7c81fc 0fb65481fd 0fb6f7 }
            // n = 7, score = 300
            //   885c8103             | mov                 byte ptr [ecx + eax*4 + 3], bl
            //   40                   | inc                 eax
            //   83f83c               | cmp                 eax, 0x3c
            //   7463                 | je                  0x65
            //   8a7c81fc             | mov                 bh, byte ptr [ecx + eax*4 - 4]
            //   0fb65481fd           | movzx               edx, byte ptr [ecx + eax*4 - 3]
            //   0fb6f7               | movzx               esi, bh

        $sequence_3 = { f20f114030 f20f10442438 f20f114038 f20f108424e0000000 f20f114058 f20f108424d8000000 f20f114050 }
            // n = 7, score = 300
            //   f20f114030           | movsd               qword ptr [eax + 0x30], xmm0
            //   f20f10442438         | movsd               xmm0, qword ptr [esp + 0x38]
            //   f20f114038           | movsd               qword ptr [eax + 0x38], xmm0
            //   f20f108424e0000000     | movsd    xmm0, qword ptr [esp + 0xe0]
            //   f20f114058           | movsd               qword ptr [eax + 0x58], xmm0
            //   f20f108424d8000000     | movsd    xmm0, qword ptr [esp + 0xd8]
            //   f20f114050           | movsd               qword ptr [eax + 0x50], xmm0

        $sequence_4 = { 0f57d8 0f115c2411 0f10442461 0f104c2421 0f109424a1000000 }
            // n = 5, score = 300
            //   0f57d8               | xorps               xmm3, xmm0
            //   0f115c2411           | movups              xmmword ptr [esp + 0x11], xmm3
            //   0f10442461           | movups              xmm0, xmmword ptr [esp + 0x61]
            //   0f104c2421           | movups              xmm1, xmmword ptr [esp + 0x21]
            //   0f109424a1000000     | movups              xmm2, xmmword ptr [esp + 0xa1]

        $sequence_5 = { 8a4627 88431c 8a4626 88431d 8a4625 88431e 8a4624 }
            // n = 7, score = 300
            //   8a4627               | mov                 al, byte ptr [esi + 0x27]
            //   88431c               | mov                 byte ptr [ebx + 0x1c], al
            //   8a4626               | mov                 al, byte ptr [esi + 0x26]
            //   88431d               | mov                 byte ptr [ebx + 0x1d], al
            //   8a4625               | mov                 al, byte ptr [esi + 0x25]
            //   88431e               | mov                 byte ptr [ebx + 0x1e], al
            //   8a4624               | mov                 al, byte ptr [esi + 0x24]

        $sequence_6 = { 8b540c48 89542438 83c104 894c2408 8b0c24 894c2430 }
            // n = 6, score = 300
            //   8b540c48             | mov                 edx, dword ptr [esp + ecx + 0x48]
            //   89542438             | mov                 dword ptr [esp + 0x38], edx
            //   83c104               | add                 ecx, 4
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   8b0c24               | mov                 ecx, dword ptr [esp]
            //   894c2430             | mov                 dword ptr [esp + 0x30], ecx

        $sequence_7 = { c7462800000000 c7462c0f000000 c6461800 f20f104010 f20f114310 }
            // n = 5, score = 300
            //   c7462800000000       | mov                 dword ptr [esi + 0x28], 0
            //   c7462c0f000000       | mov                 dword ptr [esi + 0x2c], 0xf
            //   c6461800             | mov                 byte ptr [esi + 0x18], 0
            //   f20f104010           | movsd               xmm0, qword ptr [eax + 0x10]
            //   f20f114310           | movsd               qword ptr [ebx + 0x10], xmm0

        $sequence_8 = { 8a442404 3287e4000000 884604 329fe5000000 885e05 3297e6000000 885606 }
            // n = 7, score = 300
            //   8a442404             | mov                 al, byte ptr [esp + 4]
            //   3287e4000000         | xor                 al, byte ptr [edi + 0xe4]
            //   884604               | mov                 byte ptr [esi + 4], al
            //   329fe5000000         | xor                 bl, byte ptr [edi + 0xe5]
            //   885e05               | mov                 byte ptr [esi + 5], bl
            //   3297e6000000         | xor                 dl, byte ptr [edi + 0xe6]
            //   885606               | mov                 byte ptr [esi + 6], dl

        $sequence_9 = { 0355e0 39d1 89d6 0f43f1 }
            // n = 4, score = 300
            //   0355e0               | add                 edx, dword ptr [ebp - 0x20]
            //   39d1                 | cmp                 ecx, edx
            //   89d6                 | mov                 esi, edx
            //   0f43f1               | cmovae              esi, ecx

    condition:
        7 of them and filesize < 1420288
}