rule win_badcall_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.badcall."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badcall"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? b907000000 33c0 8d7c240d }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   b907000000           | mov                 ecx, 7
            //   33c0                 | xor                 eax, eax
            //   8d7c240d             | lea                 edi, [esp + 0xd]

        $sequence_1 = { 85c0 754b bf???????? 83c9ff f2ae f7d1 49 }
            // n = 7, score = 300
            //   85c0                 | test                eax, eax
            //   754b                 | jne                 0x4d
            //   bf????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx

        $sequence_2 = { c644240c00 f3ab 66ab 8d4c242c c744240800000000 aa }
            // n = 6, score = 300
            //   c644240c00           | mov                 byte ptr [esp + 0xc], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_3 = { 8bf1 89742404 8d4e18 e8???????? }
            // n = 4, score = 300
            //   8bf1                 | mov                 esi, ecx
            //   89742404             | mov                 dword ptr [esp + 4], esi
            //   8d4e18               | lea                 ecx, [esi + 0x18]
            //   e8????????           |                     

        $sequence_4 = { 53 57 33db b97f000000 33c0 8dbc2415010000 }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   b97f000000           | mov                 ecx, 0x7f
            //   33c0                 | xor                 eax, eax
            //   8dbc2415010000       | lea                 edi, [esp + 0x115]

        $sequence_5 = { 89442412 8bf1 6685ff 66c74424080000 6689442416 746d 6a06 }
            // n = 7, score = 300
            //   89442412             | mov                 dword ptr [esp + 0x12], eax
            //   8bf1                 | mov                 esi, ecx
            //   6685ff               | test                di, di
            //   66c74424080000       | mov                 word ptr [esp + 8], 0
            //   6689442416           | mov                 word ptr [esp + 0x16], ax
            //   746d                 | je                  0x6f
            //   6a06                 | push                6

        $sequence_6 = { e8???????? 85c0 7429 8b5604 8d4c240c 51 687e660480 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7429                 | je                  0x2b
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   51                   | push                ecx
            //   687e660480           | push                0x8004667e

        $sequence_7 = { 56 89442406 57 8b7c241c 8944240e }
            // n = 5, score = 300
            //   56                   | push                esi
            //   89442406             | mov                 dword ptr [esp + 6], eax
            //   57                   | push                edi
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   8944240e             | mov                 dword ptr [esp + 0xe], eax

        $sequence_8 = { 8b44242c 85c0 0f848a020000 33c9 48 }
            // n = 5, score = 200
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   85c0                 | test                eax, eax
            //   0f848a020000         | je                  0x290
            //   33c9                 | xor                 ecx, ecx
            //   48                   | dec                 eax

        $sequence_9 = { 8b742410 8d0c12 57 8bd9 33c0 8bfe 52 }
            // n = 7, score = 200
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   8d0c12               | lea                 ecx, [edx + edx]
            //   57                   | push                edi
            //   8bd9                 | mov                 ebx, ecx
            //   33c0                 | xor                 eax, eax
            //   8bfe                 | mov                 edi, esi
            //   52                   | push                edx

        $sequence_10 = { 8b4c2410 85c9 0f849f080000 8bd1 8bcd }
            // n = 5, score = 200
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   85c9                 | test                ecx, ecx
            //   0f849f080000         | je                  0x8a5
            //   8bd1                 | mov                 edx, ecx
            //   8bcd                 | mov                 ecx, ebp

        $sequence_11 = { c1e902 f3a5 8bc8 8b442468 83e103 }
            // n = 5, score = 200
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   8b442468             | mov                 eax, dword ptr [esp + 0x68]
            //   83e103               | and                 ecx, 3

        $sequence_12 = { 5f 898834010000 5e 33c0 }
            // n = 4, score = 200
            //   5f                   | pop                 edi
            //   898834010000         | mov                 dword ptr [eax + 0x134], ecx
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_13 = { 750f 8b4614 85c0 0f87c2feffff 8b442414 8b442410 5f }
            // n = 7, score = 200
            //   750f                 | jne                 0x11
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   85c0                 | test                eax, eax
            //   0f87c2feffff         | ja                  0xfffffec8
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   5f                   | pop                 edi

        $sequence_14 = { 899014020000 8b94241c010000 898818020000 8b8c2420010000 89901c020000 }
            // n = 5, score = 200
            //   899014020000         | mov                 dword ptr [eax + 0x214], edx
            //   8b94241c010000       | mov                 edx, dword ptr [esp + 0x11c]
            //   898818020000         | mov                 dword ptr [eax + 0x218], ecx
            //   8b8c2420010000       | mov                 ecx, dword ptr [esp + 0x120]
            //   89901c020000         | mov                 dword ptr [eax + 0x21c], edx

        $sequence_15 = { 899518010000 8b542414 85d2 7409 52 }
            // n = 5, score = 200
            //   899518010000         | mov                 dword ptr [ebp + 0x118], edx
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   85d2                 | test                edx, edx
            //   7409                 | je                  0xb
            //   52                   | push                edx

        $sequence_16 = { 3bd1 7d06 ebda 3bd1 }
            // n = 4, score = 100
            //   3bd1                 | cmp                 edx, ecx
            //   7d06                 | jge                 8
            //   ebda                 | jmp                 0xffffffdc
            //   3bd1                 | cmp                 edx, ecx

        $sequence_17 = { 81ec2c010000 55 68???????? ff15???????? }
            // n = 4, score = 100
            //   81ec2c010000         | sub                 esp, 0x12c
            //   55                   | push                ebp
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_18 = { e8???????? 8b442464 6a01 8d4c242c 6a04 51 57 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b442464             | mov                 eax, dword ptr [esp + 0x64]
            //   6a01                 | push                1
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   6a04                 | push                4
            //   51                   | push                ecx
            //   57                   | push                edi

        $sequence_19 = { 5e 85c0 7406 33c0 83c454 c3 }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   33c0                 | xor                 eax, eax
            //   83c454               | add                 esp, 0x54
            //   c3                   | ret                 

        $sequence_20 = { 8bb6a48b0110 eb06 8bb6d88b0110 3bce 7e20 83e907 }
            // n = 6, score = 100
            //   8bb6a48b0110         | mov                 esi, dword ptr [esi + 0x10018ba4]
            //   eb06                 | jmp                 8
            //   8bb6d88b0110         | mov                 esi, dword ptr [esi + 0x10018bd8]
            //   3bce                 | cmp                 ecx, esi
            //   7e20                 | jle                 0x22
            //   83e907               | sub                 ecx, 7

        $sequence_21 = { 83c40c e9???????? 6a00 6883341200 57 c744242401000000 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   e9????????           |                     
            //   6a00                 | push                0
            //   6883341200           | push                0x123483
            //   57                   | push                edi
            //   c744242401000000     | mov                 dword ptr [esp + 0x24], 1

        $sequence_22 = { 8d7c240d c644240c00 f3ab 8b35???????? 68???????? }
            // n = 5, score = 100
            //   8d7c240d             | lea                 edi, [esp + 0xd]
            //   c644240c00           | mov                 byte ptr [esp + 0xc], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b35????????         |                     
            //   68????????           |                     

        $sequence_23 = { 6a00 688f341200 56 e8???????? 83c40c 57 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   688f341200           | push                0x12348f
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   57                   | push                edi

    condition:
        7 of them and filesize < 483328
}