rule win_badhatch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.badhatch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.badhatch"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8b3d???????? 85c0 7512 ffd7 53 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14
            //   ffd7                 | call                edi
            //   53                   | push                ebx

        $sequence_1 = { 83c420 5f 5e 83c574 c9 c3 55 }
            // n = 7, score = 100
            //   83c420               | add                 esp, 0x20
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c574               | add                 ebp, 0x74
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_2 = { 837df800 7435 837f0c00 742f 33c0 e9???????? 8b4f08 }
            // n = 7, score = 100
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7435                 | je                  0x37
            //   837f0c00             | cmp                 dword ptr [edi + 0xc], 0
            //   742f                 | je                  0x31
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b4f08               | mov                 ecx, dword ptr [edi + 8]

        $sequence_3 = { 7cb9 eb09 ff15???????? 8945fc 8b45fc 5f 5e }
            // n = 7, score = 100
            //   7cb9                 | jl                  0xffffffbb
            //   eb09                 | jmp                 0xb
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_4 = { 53 ff750c 8d443750 50 e8???????? 83c40c ff750c }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8d443750             | lea                 eax, [edi + esi + 0x50]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { ffd6 8d45e8 50 68???????? ff7508 e8???????? }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_6 = { 7559 ff15???????? 3dea000000 754c ff75fc 56 ff35???????? }
            // n = 7, score = 100
            //   7559                 | jne                 0x5b
            //   ff15????????         |                     
            //   3dea000000           | cmp                 eax, 0xea
            //   754c                 | jne                 0x4e
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   56                   | push                esi
            //   ff35????????         |                     

        $sequence_7 = { 03d0 03d1 52 50 e8???????? 83c40c b8ea000000 }
            // n = 7, score = 100
            //   03d0                 | add                 edx, eax
            //   03d1                 | add                 edx, ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   b8ea000000           | mov                 eax, 0xea

        $sequence_8 = { 838b40010000ff 33f6 56 56 6a01 56 }
            // n = 6, score = 100
            //   838b40010000ff       | or                  dword ptr [ebx + 0x140], 0xffffffff
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi
            //   56                   | push                esi
            //   6a01                 | push                1
            //   56                   | push                esi

        $sequence_9 = { eb05 8b450c 8938 395dfc 740e 57 53 }
            // n = 7, score = 100
            //   eb05                 | jmp                 7
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8938                 | mov                 dword ptr [eax], edi
            //   395dfc               | cmp                 dword ptr [ebp - 4], ebx
            //   740e                 | je                  0x10
            //   57                   | push                edi
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 156672
}