rule win_bagle_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bagle."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bagle"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b03d f3aa 5b 5f }
            // n = 4, score = 300
            //   b03d                 | mov                 al, 0x3d
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi

        $sequence_1 = { e340 ac c1e010 83f901 740b }
            // n = 5, score = 300
            //   e340                 | jecxz               0x42
            //   ac                   | lodsb               al, byte ptr [esi]
            //   c1e010               | shl                 eax, 0x10
            //   83f901               | cmp                 ecx, 1
            //   740b                 | je                  0xd

        $sequence_2 = { 56 57 53 8b7508 8b7d0c 8b4d10 33db }
            // n = 7, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   33db                 | xor                 ebx, ebx

        $sequence_3 = { 6a00 6a00 6a04 50 e8???????? 0bc0 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   e8????????           |                     
            //   0bc0                 | or                  eax, eax

        $sequence_4 = { 042b aa c3 55 8bec }
            // n = 5, score = 300
            //   042b                 | add                 al, 0x2b
            //   aa                   | stosb               byte ptr es:[edi], al
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_5 = { 68???????? e8???????? 68???????? 68???????? e8???????? 6804010000 }
            // n = 6, score = 300
            //   68????????           |                     
            //   e8????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   6804010000           | push                0x104

        $sequence_6 = { 2bf9 b03d f3aa 5b }
            // n = 4, score = 300
            //   2bf9                 | sub                 edi, ecx
            //   b03d                 | mov                 al, 0x3d
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   5b                   | pop                 ebx

        $sequence_7 = { 2bf9 b03d f3aa 5b 5f 5e }
            // n = 6, score = 300
            //   2bf9                 | sub                 edi, ecx
            //   b03d                 | mov                 al, 0x3d
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { 0bc0 7426 6880000000 68???????? }
            // n = 4, score = 300
            //   0bc0                 | or                  eax, eax
            //   7426                 | je                  0x28
            //   6880000000           | push                0x80
            //   68????????           |                     

        $sequence_9 = { 668945f2 c745f400000000 6a06 6a01 6a02 e8???????? 8bd8 }
            // n = 7, score = 300
            //   668945f2             | mov                 word ptr [ebp - 0xe], ax
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   6a06                 | push                6
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

    condition:
        7 of them and filesize < 245760
}