rule win_bamital_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bamital."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bamital"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 803820 7516 83c101 83f901 7504 8bd0 }
            // n = 6, score = 300
            //   803820               | cmp                 byte ptr [eax], 0x20
            //   7516                 | jne                 0x18
            //   83c101               | add                 ecx, 1
            //   83f901               | cmp                 ecx, 1
            //   7504                 | jne                 6
            //   8bd0                 | mov                 edx, eax

        $sequence_1 = { 2945f8 ff75f8 e8???????? 5e ff75f8 56 }
            // n = 6, score = 300
            //   2945f8               | sub                 dword ptr [ebp - 8], eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   5e                   | pop                 esi
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   56                   | push                esi

        $sequence_2 = { 33c0 5e 5f 5b 5a 59 }
            // n = 6, score = 300
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx

        $sequence_3 = { 52 e8???????? 837dd800 7505 e9???????? }
            // n = 5, score = 300
            //   52                   | push                edx
            //   e8????????           |                     
            //   837dd800             | cmp                 dword ptr [ebp - 0x28], 0
            //   7505                 | jne                 7
            //   e9????????           |                     

        $sequence_4 = { b910000000 f3ab eb0c 8bcb f3a4 011d???????? }
            // n = 6, score = 300
            //   b910000000           | mov                 ecx, 0x10
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   eb0c                 | jmp                 0xe
            //   8bcb                 | mov                 ecx, ebx
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   011d????????         |                     

        $sequence_5 = { 8b55fc 8945fc 0bd2 7406 52 e8???????? }
            // n = 6, score = 300
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   0bd2                 | or                  edx, edx
            //   7406                 | je                  8
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_6 = { 5b 5a 59 c9 c21000 33c0 5e }
            // n = 7, score = 300
            //   5b                   | pop                 ebx
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx
            //   c9                   | leave               
            //   c21000               | ret                 0x10
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi

        $sequence_7 = { 83c024 6a00 50 e8???????? }
            // n = 4, score = 300
            //   83c024               | add                 eax, 0x24
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 75f1 8d0411 33c2 5f 5e c9 }
            // n = 6, score = 300
            //   75f1                 | jne                 0xfffffff3
            //   8d0411               | lea                 eax, [ecx + edx]
            //   33c2                 | xor                 eax, edx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_9 = { e8???????? 83c708 57 ff7004 e8???????? 83c708 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   83c708               | add                 edi, 8
            //   57                   | push                edi
            //   ff7004               | push                dword ptr [eax + 4]
            //   e8????????           |                     
            //   83c708               | add                 edi, 8

    condition:
        7 of them and filesize < 90112
}