rule win_banatrix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.banatrix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.banatrix"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8b470c 85c0 74e3 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   85c0                 | test                eax, eax
            //   74e3                 | je                  0xffffffe5

        $sequence_1 = { 8b45cc d16dd0 8b4dd0 8d34c8 8b0e 81e1ffffff7f 034dc8 }
            // n = 7, score = 200
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   d16dd0               | shr                 dword ptr [ebp - 0x30], 1
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   8d34c8               | lea                 esi, [eax + ecx*8]
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   81e1ffffff7f         | and                 ecx, 0x7fffffff
            //   034dc8               | add                 ecx, dword ptr [ebp - 0x38]

        $sequence_2 = { 0f44d0 e9???????? 7418 8b75d4 }
            // n = 4, score = 200
            //   0f44d0               | cmove               edx, eax
            //   e9????????           |                     
            //   7418                 | je                  0x1a
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]

        $sequence_3 = { 89c2 ebe0 0f86dc000000 8d7101 }
            // n = 4, score = 200
            //   89c2                 | mov                 edx, eax
            //   ebe0                 | jmp                 0xffffffe2
            //   0f86dc000000         | jbe                 0xe2
            //   8d7101               | lea                 esi, [ecx + 1]

        $sequence_4 = { 5f 5d c3 55 89e5 83ec28 8b4514 }
            // n = 7, score = 200
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec28               | sub                 esp, 0x28
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_5 = { 8d4101 c74424080a000000 890424 c745e400000000 e8???????? 89c6 }
            // n = 6, score = 200
            //   8d4101               | lea                 eax, [ecx + 1]
            //   c74424080a000000     | mov                 dword ptr [esp + 8], 0xa
            //   890424               | mov                 dword ptr [esp], eax
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   e8????????           |                     
            //   89c6                 | mov                 esi, eax

        $sequence_6 = { 894314 8b4510 897b04 c7430800000000 c7431000000000 }
            // n = 5, score = 200
            //   894314               | mov                 dword ptr [ebx + 0x14], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   897b04               | mov                 dword ptr [ebx + 4], edi
            //   c7430800000000       | mov                 dword ptr [ebx + 8], 0
            //   c7431000000000       | mov                 dword ptr [ebx + 0x10], 0

        $sequence_7 = { 010c37 ff45d0 ebcb 01fa ebb4 8b7dd0 }
            // n = 6, score = 200
            //   010c37               | add                 dword ptr [edi + esi], ecx
            //   ff45d0               | inc                 dword ptr [ebp - 0x30]
            //   ebcb                 | jmp                 0xffffffcd
            //   01fa                 | add                 edx, edi
            //   ebb4                 | jmp                 0xffffffb6
            //   8b7dd0               | mov                 edi, dword ptr [ebp - 0x30]

        $sequence_8 = { e8???????? 895c2408 c744240400000000 890424 e8???????? 83ec0c }
            // n = 6, score = 200
            //   e8????????           |                     
            //   895c2408             | mov                 dword ptr [esp + 8], ebx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83ec0c               | sub                 esp, 0xc

        $sequence_9 = { 83ec10 85c0 8945d4 7542 8b45d0 c744240c04000000 c744240800300000 }
            // n = 7, score = 200
            //   83ec10               | sub                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   7542                 | jne                 0x44
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   c744240c04000000     | mov                 dword ptr [esp + 0xc], 4
            //   c744240800300000     | mov                 dword ptr [esp + 8], 0x3000

    condition:
        7 of them and filesize < 180224
}