rule win_bangat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bangat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bangat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8d45fc 50 e8???????? 8b4508 8325????????00 83c418 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8325????????00       |                     
            //   83c418               | add                 esp, 0x18

        $sequence_1 = { 3bc7 7d02 8bc7 50 ff75d8 68???????? 56 }
            // n = 7, score = 100
            //   3bc7                 | cmp                 eax, edi
            //   7d02                 | jge                 4
            //   8bc7                 | mov                 eax, edi
            //   50                   | push                eax
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_2 = { 8a8888f44000 ff248d30f44000 8b5e6c 5f 8bc3 5e 5b }
            // n = 7, score = 100
            //   8a8888f44000         | mov                 cl, byte ptr [eax + 0x40f488]
            //   ff248d30f44000       | jmp                 dword ptr [ecx*4 + 0x40f430]
            //   8b5e6c               | mov                 ebx, dword ptr [esi + 0x6c]
            //   5f                   | pop                 edi
            //   8bc3                 | mov                 eax, ebx
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_3 = { 33c9 8a4c2432 8a9950ec4700 33c9 8aa850ec4700 8bfb }
            // n = 6, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   8a4c2432             | mov                 cl, byte ptr [esp + 0x32]
            //   8a9950ec4700         | mov                 bl, byte ptr [ecx + 0x47ec50]
            //   33c9                 | xor                 ecx, ecx
            //   8aa850ec4700         | mov                 ch, byte ptr [eax + 0x47ec50]
            //   8bfb                 | mov                 edi, ebx

        $sequence_4 = { 6859020000 68???????? 68fc000000 6a77 6a14 e8???????? }
            // n = 6, score = 100
            //   6859020000           | push                0x259
            //   68????????           |                     
            //   68fc000000           | push                0xfc
            //   6a77                 | push                0x77
            //   6a14                 | push                0x14
            //   e8????????           |                     

        $sequence_5 = { 8b348d50e84700 33c6 8d7720 8bbff0000000 33c5 d1ff 4f }
            // n = 7, score = 100
            //   8b348d50e84700       | mov                 esi, dword ptr [ecx*4 + 0x47e850]
            //   33c6                 | xor                 eax, esi
            //   8d7720               | lea                 esi, [edi + 0x20]
            //   8bbff0000000         | mov                 edi, dword ptr [edi + 0xf0]
            //   33c5                 | xor                 eax, ebp
            //   d1ff                 | sar                 edi, 1
            //   4f                   | dec                 edi

        $sequence_6 = { 83c40c 6a0a 53 53 8d45f4 53 }
            // n = 6, score = 100
            //   83c40c               | add                 esp, 0xc
            //   6a0a                 | push                0xa
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   53                   | push                ebx

        $sequence_7 = { ff15???????? 85c0 742d 8d85d4feffff 50 8d85d4f5ffff 68???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   742d                 | je                  0x2f
            //   8d85d4feffff         | lea                 eax, [ebp - 0x12c]
            //   50                   | push                eax
            //   8d85d4f5ffff         | lea                 eax, [ebp - 0xa2c]
            //   68????????           |                     

        $sequence_8 = { 895c2424 897c2428 e8???????? 83c414 e8???????? 53 }
            // n = 6, score = 100
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   897c2428             | mov                 dword ptr [esp + 0x28], edi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_9 = { 85c0 749b 6803002e00 6a00 6812030000 68ffff0000 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   749b                 | je                  0xffffff9d
            //   6803002e00           | push                0x2e0003
            //   6a00                 | push                0
            //   6812030000           | push                0x312
            //   68ffff0000           | push                0xffff

    condition:
        7 of them and filesize < 1228800
}