rule win_banjori_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.banjori."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.banjori"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f1 b0ec fd f2ae 817ffd8bff558b 75f5 fc }
            // n = 7, score = 100
            //   75f1                 | jne                 0xfffffff3
            //   b0ec                 | mov                 al, 0xec
            //   fd                   | std                 
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   817ffd8bff558b       | cmp                 dword ptr [edi - 3], 0x8b55ff8b
            //   75f5                 | jne                 0xfffffff7
            //   fc                   | cld                 

        $sequence_1 = { ff15???????? ff75ec ff15???????? 40 50 ff75ec 6a01 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff15????????         |                     
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   6a01                 | push                1

        $sequence_2 = { ff75f8 ff15???????? 8d3dac169500 57 ff15???????? 40 50 }
            // n = 7, score = 100
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   8d3dac169500         | lea                 edi, [0x9516ac]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_3 = { 53 53 53 8d45ec 50 ff75f0 ff75f8 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_4 = { 8985b0feffff 83f864 0f82c2000000 40 50 6a40 ff15???????? }
            // n = 7, score = 100
            //   8985b0feffff         | mov                 dword ptr [ebp - 0x150], eax
            //   83f864               | cmp                 eax, 0x64
            //   0f82c2000000         | jb                  0xc8
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_5 = { 395df0 741b 53 53 53 53 53 }
            // n = 7, score = 100
            //   395df0               | cmp                 dword ptr [ebp - 0x10], ebx
            //   741b                 | je                  0x1d
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_6 = { e9???????? 55 8bec 83c4f4 57 56 53 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c4f4               | add                 esp, -0xc
            //   57                   | push                edi
            //   56                   | push                esi
            //   53                   | push                ebx

        $sequence_7 = { 0145f4 6a42 ff75f4 ff75f8 ff15???????? 8945f8 ff75dc }
            // n = 7, score = 100
            //   0145f4               | add                 dword ptr [ebp - 0xc], eax
            //   6a42                 | push                0x42
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   ff75dc               | push                dword ptr [ebp - 0x24]

        $sequence_8 = { 68f1000000 51 ff15???????? 8b4e08 e32c 894de4 895de8 }
            // n = 7, score = 100
            //   68f1000000           | push                0xf1
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   e32c                 | jecxz               0x2e
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx

        $sequence_9 = { 7808 3d64696a6e 90 7507 e8???????? ebc7 ff35???????? }
            // n = 7, score = 100
            //   7808                 | js                  0xa
            //   3d64696a6e           | cmp                 eax, 0x6e6a6964
            //   90                   | nop                 
            //   7507                 | jne                 9
            //   e8????????           |                     
            //   ebc7                 | jmp                 0xffffffc9
            //   ff35????????         |                     

    condition:
        7 of them and filesize < 139264
}