rule win_bankshot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bankshot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bankshot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 81ec48040000 a1???????? 33c5 8945f8 53 }
            // n = 6, score = 300
            //   8bec                 | lea                 edx, [ebp - 0x20]
            //   81ec48040000         | dec                 eax
            //   a1????????           |                     
            //   33c5                 | mov                 ecx, ebx
            //   8945f8               | dec                 eax
            //   53                   | lea                 edx, [0xfaaa]

        $sequence_1 = { 8bf8 8d5101 8a01 41 84c0 75f9 57 }
            // n = 7, score = 300
            //   8bf8                 | dec                 eax
            //   8d5101               | lea                 ecx, [esp + 0x20]
            //   8a01                 | dec                 eax
            //   41                   | test                eax, eax
            //   84c0                 | jne                 0x1cc
            //   75f9                 | inc                 esp
            //   57                   | lea                 ecx, [eax + 0x70]

        $sequence_2 = { 68???????? ff7604 ff15???????? 81be2005000000008000 894608 751c 6a04 }
            // n = 7, score = 200
            //   68????????           |                     
            //   ff7604               | push                ebx
            //   ff15????????         |                     
            //   81be2005000000008000     | mov    ebp, esp
            //   894608               | sub                 esp, 0x448
            //   751c                 | xor                 eax, ebp
            //   6a04                 | mov                 dword ptr [ebp - 8], eax

        $sequence_3 = { 0f2815???????? 8bf2 2bf0 660f1f440000 0f10840de43fffff 0f28ca 660fefc8 }
            // n = 7, score = 200
            //   0f2815????????       |                     
            //   8bf2                 | push                ebx
            //   2bf0                 | mov                 edi, eax
            //   660f1f440000         | lea                 edx, [ecx + 1]
            //   0f10840de43fffff     | mov                 al, byte ptr [ecx]
            //   0f28ca               | inc                 ecx
            //   660fefc8             | test                al, al

        $sequence_4 = { 0fb611 0fb6c0 eb17 81fa00010000 7313 8a87bce10110 }
            // n = 6, score = 200
            //   0fb611               | cmp                 byte ptr [eax], 0
            //   0fb6c0               | mov                 al, byte ptr [edi + 0x1001e1bc]
            //   eb17                 | or                  byte ptr [esi + edx + 0x19], al
            //   81fa00010000         | inc                 edx
            //   7313                 | movzx               eax, byte ptr [ecx + 1]
            //   8a87bce10110         | push                6

        $sequence_5 = { 83c8e0 40 0f280d???????? 8bf2 2bf0 660f1f440000 0f10840de4bfffff }
            // n = 7, score = 200
            //   83c8e0               | mov                 cl, byte ptr [eax]
            //   40                   | mov                 byte ptr [ebp - 0xc54], cl
            //   0f280d????????       |                     
            //   8bf2                 | add                 dword ptr [ebp - 0xc80], 1
            //   2bf0                 | push                ebp
            //   660f1f440000         | mov                 ebp, esp
            //   0f10840de4bfffff     | sub                 esp, 0x448

        $sequence_6 = { 6a01 56 56 8975fc ff15???????? 85c0 7450 }
            // n = 7, score = 200
            //   6a01                 | jne                 0
            //   56                   | push                edi
            //   56                   | xor                 eax, eax
            //   8975fc               | push                0x20000000
            //   ff15????????         |                     
            //   85c0                 | mov                 word ptr [ebp + esi*2 - 0x434], ax
            //   7450                 | lea                 eax, [ebp - 0x434]

        $sequence_7 = { c74048b8e40110 8b4508 6689486c 8b4508 66898872010000 8b4508 83a04c03000000 }
            // n = 7, score = 200
            //   c74048b8e40110       | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b4508               | cmp                 dword ptr [eax + 0x1001e1c0], ebx
            //   6689486c             | je                  0xf9
            //   8b4508               | inc                 ecx
            //   66898872010000       | push                edi
            //   8b4508               | push                eax
            //   83a04c03000000       | add                 esp, 0xc

        $sequence_8 = { 8b45fc 817848b8e40110 7409 ff7048 e8???????? 59 c70701000000 }
            // n = 7, score = 200
            //   8b45fc               | lea                 eax, [edi + 7]
            //   817848b8e40110       | push                eax
            //   7409                 | add                 esp, 8
            //   ff7048               | mov                 dword ptr [esp + 0x4a8], 0
            //   e8????????           |                     
            //   59                   | mov                 dword ptr [esp + 0x4a4], 0x3b3009
            //   c70701000000         | lea                 eax, [esp + 0x4a4]

        $sequence_9 = { 57 50 e8???????? 83c40c 6b45e430 8945e0 8d80d0e10110 }
            // n = 7, score = 200
            //   57                   | add                 eax, 0x30
            //   50                   | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   83c40c               | mov                 eax, dword ptr [eax + 0x48]
            //   6b45e430             | lock xadd           dword ptr [eax], ebx
            //   8945e0               | dec                 ebx
            //   8d80d0e10110         | jne                 0x1f

        $sequence_10 = { 81fa00010000 7313 8a87bce10110 08441619 42 0fb64101 }
            // n = 6, score = 200
            //   81fa00010000         | lea                 edx, [eax + 0x1001e1c4]
            //   7313                 | pop                 edi
            //   8a87bce10110         | mov                 ax, word ptr [edx]
            //   08441619             | mov                 dword ptr [eax + 0x48], 0x1001e4b8
            //   42                   | mov                 eax, dword ptr [ebp + 8]
            //   0fb64101             | mov                 word ptr [eax + 0x6c], cx

        $sequence_11 = { 894de4 3998c0e10110 0f84ea000000 41 83c030 894de4 3df0000000 }
            // n = 7, score = 200
            //   894de4               | mov                 al, byte ptr [edi + 0x1001e1bc]
            //   3998c0e10110         | or                  byte ptr [esi + edx + 0x19], al
            //   0f84ea000000         | inc                 edx
            //   41                   | movzx               eax, byte ptr [ecx + 1]
            //   83c030               | jmp                 0x19
            //   894de4               | cmp                 edx, 0x100
            //   3df0000000           | jae                 0x15

        $sequence_12 = { 33c0 6800000020 66898475ccfbffff 8d85ccfbffff }
            // n = 4, score = 200
            //   33c0                 | movzx               ecx, word ptr [ebp - 0xa]
            //   6800000020           | mov                 edx, dword ptr [ebp - 0xc80]
            //   66898475ccfbffff     | mov                 dword ptr [ebp - 0xcec], edx
            //   8d85ccfbffff         | mov                 eax, dword ptr [ebp - 0xc80]

        $sequence_13 = { e8???????? 83c40c e8???????? 99 b907000000 f7f9 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c40c               | mov                 dword ptr [ebp - 0x1c], ecx
            //   e8????????           |                     
            //   99                   | cmp                 dword ptr [eax + 0x1001e1c0], ebx
            //   b907000000           | je                  0xfb
            //   f7f9                 | inc                 ecx

        $sequence_14 = { 8a06 8d7601 884431ff 84c0 75f3 68???????? 8d730c }
            // n = 7, score = 200
            //   8a06                 | xor                 eax, ebp
            //   8d7601               | mov                 dword ptr [ebp - 8], eax
            //   884431ff             | push                ebx
            //   84c0                 | sub                 esp, 0x448
            //   75f3                 | xor                 eax, ebp
            //   68????????           |                     
            //   8d730c               | mov                 dword ptr [ebp - 8], eax

        $sequence_15 = { c700???????? 8b4508 898850030000 8b4508 59 c74048b8e40110 8b4508 }
            // n = 7, score = 200
            //   c700????????         |                     
            //   8b4508               | or                  byte ptr [esi + edx + 0x19], al
            //   898850030000         | inc                 edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   59                   | pop                 ecx
            //   c74048b8e40110       | mov                 dword ptr [eax + 0x48], 0x1001e4b8
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_16 = { e8???????? 83c404 89861c020000 8b45e0 8d4e0c 6a06 8d90c4e10110 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | push                dword ptr [eax + 0x48]
            //   89861c020000         | mov                 eax, dword ptr [ebp - 0x20]
            //   8b45e0               | lea                 ecx, [esi + 0xc]
            //   8d4e0c               | push                6
            //   6a06                 | lea                 edx, [eax + 0x1001e1c4]
            //   8d90c4e10110         | pop                 edi

        $sequence_17 = { c644243b7b c644243cc1 884c243d c644243ef5 }
            // n = 4, score = 100
            //   c644243b7b           | cdq                 
            //   c644243cc1           | mov                 ecx, 7
            //   884c243d             | idiv                ecx
            //   c644243ef5           | add                 esp, 0xc

        $sequence_18 = { 6b05????????3c 0305???????? 0fb74df4 6bd13c 0fb74df6 }
            // n = 5, score = 100
            //   6b05????????3c       |                     
            //   0305????????         |                     
            //   0fb74df4             | mov                 ecx, 7
            //   6bd13c               | add                 edx, 0xf
            //   0fb74df6             | mov                 dword ptr [ebp - 0x24], edx

        $sequence_19 = { 8b442454 50 ff15???????? b801000000 }
            // n = 4, score = 100
            //   8b442454             | test                eax, eax
            //   50                   | je                  0x17
            //   ff15????????         |                     
            //   b801000000           | push                eax

        $sequence_20 = { 488d91f00f0000 e8???????? 41bb12000000 488d158b760000 }
            // n = 4, score = 100
            //   488d91f00f0000       | lea                 edx, [ebp - 0x40]
            //   e8????????           |                     
            //   41bb12000000         | dec                 eax
            //   488d158b760000       | mov                 ecx, ebx

        $sequence_21 = { 51 8d9508f8ffff 52 ff15???????? }
            // n = 4, score = 100
            //   51                   | mov                 ax, word ptr [edx]
            //   8d9508f8ffff         | lea                 edx, [edx + 2]
            //   52                   | add                 esp, 0xc
            //   ff15????????         |                     

        $sequence_22 = { 83c20f 8955dc 8b55ec 81c2e80e0000 52 }
            // n = 5, score = 100
            //   83c20f               | mov                 ax, word ptr [edx]
            //   8955dc               | lea                 edx, [edx + 2]
            //   8b55ec               | mov                 dword ptr [ebp - 0x1c], ecx
            //   81c2e80e0000         | cmp                 dword ptr [eax + 0x1001e1c0], ebx
            //   52                   | je                  0xf6

        $sequence_23 = { 41ffcb 4183cbf0 41ffc3 488d9530010000 b904010000 44891d???????? }
            // n = 6, score = 100
            //   41ffcb               | dec                 eax
            //   4183cbf0             | lea                 ecx, [esp + 0x20]
            //   41ffc3               | inc                 ecx
            //   488d9530010000       | dec                 ebx
            //   b904010000           | inc                 ecx
            //   44891d????????       |                     

        $sequence_24 = { 895c242c ff15???????? b910000000 33c0 }
            // n = 4, score = 100
            //   895c242c             | cdq                 
            //   ff15????????         |                     
            //   b910000000           | mov                 ecx, 7
            //   33c0                 | add                 esp, 0xc

        $sequence_25 = { 2b8534feffff 3dd0070000 7307 33c0 e9???????? 8d8d5cfeffff 51 }
            // n = 7, score = 100
            //   2b8534feffff         | idiv                ecx
            //   3dd0070000           | add                 esp, 0xc
            //   7307                 | cdq                 
            //   33c0                 | mov                 ecx, 7
            //   e9????????           |                     
            //   8d8d5cfeffff         | add                 esp, 0xc
            //   51                   | cdq                 

        $sequence_26 = { 57 e8???????? 83c40c 85c0 7506 8d4707 50 }
            // n = 7, score = 100
            //   57                   | push                ebx
            //   e8????????           |                     
            //   83c40c               | mov                 edi, eax
            //   85c0                 | lea                 edx, [ecx + 1]
            //   7506                 | mov                 al, byte ptr [ecx]
            //   8d4707               | inc                 ecx
            //   50                   | test                al, al

        $sequence_27 = { e8???????? 83c408 c78424a804000000000000 c78424a404000009303b00 8d8424a4040000 6808040000 eb80 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | jne                 0
            //   c78424a804000000000000     | push    edi
            //   c78424a404000009303b00     | sub    esp, 0x448
            //   8d8424a4040000       | xor                 eax, ebp
            //   6808040000           | mov                 dword ptr [ebp - 8], eax
            //   eb80                 | push                ebx

        $sequence_28 = { c785a4fbffff00000000 682c010000 ff15???????? c705????????00000000 68???????? ff15???????? }
            // n = 6, score = 100
            //   c785a4fbffff00000000     | inc    ecx
            //   682c010000           | add                 eax, 0x30
            //   ff15????????         |                     
            //   c705????????00000000     |     
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_29 = { ff15???????? 4885c0 0f85a7010000 448d4870 448d402e 488d15ce520000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   4885c0               | dec                 eax
            //   0f85a7010000         | mov                 dword ptr [esp + 0x45b8], edi
            //   448d4870             | dec                 esp
            //   448d402e             | mov                 dword ptr [esp + 0x45c0], ebp
            //   488d15ce520000       | dec                 eax

        $sequence_30 = { 488d55c0 488bcb ff15???????? 4885c0 0f85df020000 488d55e0 488bcb }
            // n = 7, score = 100
            //   488d55c0             | jmp                 edx
            //   488bcb               | dec                 ecx
            //   ff15????????         |                     
            //   4885c0               | lea                 edx, [ecx + 6]
            //   0f85df020000         | dec                 eax
            //   488d55e0             | mov                 ecx, edi
            //   488bcb               | ret                 

        $sequence_31 = { 59 eb33 8b7dd0 8b45e4 8b4de8 8b0485c8887100 }
            // n = 6, score = 100
            //   59                   | cdq                 
            //   eb33                 | mov                 ecx, 7
            //   8b7dd0               | idiv                ecx
            //   8b45e4               | add                 esp, 0xc
            //   8b4de8               | cdq                 
            //   8b0485c8887100       | mov                 ecx, 7

        $sequence_32 = { 57 c685b8feffff00 6803010000 6a00 8d85b9feffff 50 }
            // n = 6, score = 100
            //   57                   | mov                 dword ptr [ebp - 0x1c], ecx
            //   c685b8feffff00       | cmp                 eax, 0xf0
            //   6803010000           | lea                 ecx, [esi + 0xc]
            //   6a00                 | push                6
            //   8d85b9feffff         | lea                 edx, [eax + 0x1001e1c4]
            //   50                   | pop                 edi

        $sequence_33 = { e8???????? a1???????? 0f1005???????? 898584fbffff 66a1???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   0f1005????????       |                     
            //   898584fbffff         | dec                 esp
            //   66a1????????         |                     

        $sequence_34 = { c64424210d e8???????? 8b4c2410 8b542414 8b442418 890d???????? }
            // n = 6, score = 100
            //   c64424210d           | add                 esp, 0xc
            //   e8????????           |                     
            //   8b4c2410             | cdq                 
            //   8b542414             | mov                 ecx, 7
            //   8b442418             | add                 esp, 0xc
            //   890d????????         |                     

        $sequence_35 = { c6442421cd c64424229c c64424231d c644242436 }
            // n = 4, score = 100
            //   c6442421cd           | cdq                 
            //   c64424229c           | mov                 ecx, 7
            //   c64424231d           | idiv                ecx
            //   c644242436           | mov                 byte ptr [esp + 0x1b], 0xc4

        $sequence_36 = { 57 8db8607d0110 57 ff15???????? ff0d???????? 83ef18 }
            // n = 6, score = 100
            //   57                   | dec                 eax
            //   8db8607d0110         | mov                 dword ptr [esp + 0x120], eax
            //   57                   | dec                 eax
            //   ff15????????         |                     
            //   ff0d????????         |                     
            //   83ef18               | mov                 eax, dword ptr [ecx + 0x1c]

        $sequence_37 = { c644241bc4 c644241c90 c644241d9c c644241e46 c644241f7b c64424209d }
            // n = 6, score = 100
            //   c644241bc4           | movups              xmm0, xmmword ptr [ebp + ecx - 0xc01c]
            //   c644241c90           | movaps              xmm1, xmm2
            //   c644241d9c           | pxor                xmm1, xmm0
            //   c644241e46           | push                1
            //   c644241f7b           | push                esi
            //   c64424209d           | push                esi

        $sequence_38 = { 4803d1 ffe2 4c8b05???????? 498d5106 488bcf }
            // n = 5, score = 100
            //   4803d1               | or                  ebx, 0xfffffff0
            //   ffe2                 | inc                 ecx
            //   4c8b05????????       |                     
            //   498d5106             | inc                 ebx
            //   488bcf               | dec                 eax

        $sequence_39 = { ff15???????? 488d15a6f20000 488d4c2420 488905???????? }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   488d15a6f20000       | dec                 eax
            //   488d4c2420           | lea                 edx, [0xf2a6]
            //   488905????????       |                     

        $sequence_40 = { 33c0 ffc2 83fa0a 7ce4 b80b000000 c3 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   ffc2                 | inc                 edx
            //   83fa0a               | cmp                 edx, 0xa
            //   7ce4                 | jl                  0xffffffe6
            //   b80b000000           | mov                 eax, 0xb
            //   c3                   | ret                 

        $sequence_41 = { 83c410 8d4c2460 8d542408 51 683f000f00 6a00 }
            // n = 6, score = 100
            //   83c410               | mov                 dword ptr [ebp - 4], esi
            //   8d4c2460             | test                eax, eax
            //   8d542408             | je                  0x58
            //   51                   | test                edx, edx
            //   683f000f00           | jne                 0x53
            //   6a00                 | mov                 eax, dword ptr [ebp - 0xc78c]

        $sequence_42 = { c3 4889b424b0450000 4889bc24b8450000 4c89ac24c0450000 }
            // n = 4, score = 100
            //   c3                   | lea                 edx, [ebp + 0x130]
            //   4889b424b0450000     | mov                 ecx, 0x104
            //   4889bc24b8450000     | dec                 eax
            //   4c89ac24c0450000     | add                 edx, ecx

        $sequence_43 = { 83c40c 8d85bcfbffff 50 6804010000 ff15???????? 8d85bcfeffff 50 }
            // n = 7, score = 100
            //   83c40c               | mov                 esi, edx
            //   8d85bcfbffff         | mov                 ecx, dword ptr [eax + 0x90]
            //   50                   | mov                 ebp, esp
            //   6804010000           | sub                 esp, 0x448
            //   ff15????????         |                     
            //   8d85bcfeffff         | xor                 eax, ebp
            //   50                   | mov                 dword ptr [ebp - 8], eax

        $sequence_44 = { 57 8b3d???????? 8bf1 68???????? 89b55cf2ffff 660fd645f0 8945f8 }
            // n = 7, score = 100
            //   57                   | push                ebp
            //   8b3d????????         |                     
            //   8bf1                 | mov                 ebp, esp
            //   68????????           |                     
            //   89b55cf2ffff         | sub                 esp, 0x448
            //   660fd645f0           | xor                 eax, ebp
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

    condition:
        7 of them and filesize < 860160
}