rule win_bbsrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bbsrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bbsrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3b0a 7411 837e3800 7d05 8d48fa 890b }
            // n = 6, score = 100
            //   3b0a                 | cmp                 ecx, dword ptr [edx]
            //   7411                 | je                  0x13
            //   837e3800             | cmp                 dword ptr [esi + 0x38], 0
            //   7d05                 | jge                 7
            //   8d48fa               | lea                 ecx, [eax - 6]
            //   890b                 | mov                 dword ptr [ebx], ecx

        $sequence_1 = { 52 50 55 e8???????? 8d8c2418140000 51 68???????? }
            // n = 7, score = 100
            //   52                   | push                edx
            //   50                   | push                eax
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8d8c2418140000       | lea                 ecx, [esp + 0x1418]
            //   51                   | push                ecx
            //   68????????           |                     

        $sequence_2 = { 3b7e28 7cf2 8b4b10 2b4b0c f7c1f0ffffff 0f84c1000000 8b5618 }
            // n = 7, score = 100
            //   3b7e28               | cmp                 edi, dword ptr [esi + 0x28]
            //   7cf2                 | jl                  0xfffffff4
            //   8b4b10               | mov                 ecx, dword ptr [ebx + 0x10]
            //   2b4b0c               | sub                 ecx, dword ptr [ebx + 0xc]
            //   f7c1f0ffffff         | test                ecx, 0xfffffff0
            //   0f84c1000000         | je                  0xc7
            //   8b5618               | mov                 edx, dword ptr [esi + 0x18]

        $sequence_3 = { 3488 34a8 34b0 34c4 34cc 34e0 34e8 }
            // n = 7, score = 100
            //   3488                 | xor                 al, 0x88
            //   34a8                 | xor                 al, 0xa8
            //   34b0                 | xor                 al, 0xb0
            //   34c4                 | xor                 al, 0xc4
            //   34cc                 | xor                 al, 0xcc
            //   34e0                 | xor                 al, 0xe0
            //   34e8                 | xor                 al, 0xe8

        $sequence_4 = { 33db f7442410fcffffff 0f86d5000000 6800060000 8d8c241c100000 56 }
            // n = 6, score = 100
            //   33db                 | xor                 ebx, ebx
            //   f7442410fcffffff     | test                dword ptr [esp + 0x10], 0xfffffffc
            //   0f86d5000000         | jbe                 0xdb
            //   6800060000           | push                0x600
            //   8d8c241c100000       | lea                 ecx, [esp + 0x101c]
            //   56                   | push                esi

        $sequence_5 = { 8bd0 89442428 83fe04 722c 8bff 8b0a 8b542414 }
            // n = 7, score = 100
            //   8bd0                 | mov                 edx, eax
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   83fe04               | cmp                 esi, 4
            //   722c                 | jb                  0x2e
            //   8bff                 | mov                 edi, edi
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]

        $sequence_6 = { 52 897b08 e8???????? f7d8 1bc0 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   897b08               | mov                 dword ptr [ebx + 8], edi
            //   e8????????           |                     
            //   f7d8                 | neg                 eax
            //   1bc0                 | sbb                 eax, eax

        $sequence_7 = { e8???????? 6a36 8d4c246c 51 8d5610 6a46 52 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a36                 | push                0x36
            //   8d4c246c             | lea                 ecx, [esp + 0x6c]
            //   51                   | push                ecx
            //   8d5610               | lea                 edx, [esi + 0x10]
            //   6a46                 | push                0x46
            //   52                   | push                edx

        $sequence_8 = { e8???????? 85c0 752d 8b560c 895608 ff15???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   752d                 | jne                 0x2f
            //   8b560c               | mov                 edx, dword ptr [esi + 0xc]
            //   895608               | mov                 dword ptr [esi + 8], edx
            //   ff15????????         |                     

        $sequence_9 = { 7536 80780300 7530 80780400 752a 80780500 7524 }
            // n = 7, score = 100
            //   7536                 | jne                 0x38
            //   80780300             | cmp                 byte ptr [eax + 3], 0
            //   7530                 | jne                 0x32
            //   80780400             | cmp                 byte ptr [eax + 4], 0
            //   752a                 | jne                 0x2c
            //   80780500             | cmp                 byte ptr [eax + 5], 0
            //   7524                 | jne                 0x26

    condition:
        7 of them and filesize < 434176
}