rule win_beast_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.beast."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.beast"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 57 33ff 6a03 47 59 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   6a03                 | push                3
            //   47                   | inc                 edi
            //   59                   | pop                 ecx

        $sequence_1 = { 330c8550b44f00 334d1c 83c520 894c242c 83ef01 0f85f0fdffff 8b442410 }
            // n = 7, score = 100
            //   330c8550b44f00       | xor                 ecx, dword ptr [eax*4 + 0x4fb450]
            //   334d1c               | xor                 ecx, dword ptr [ebp + 0x1c]
            //   83c520               | add                 ebp, 0x20
            //   894c242c             | mov                 dword ptr [esp + 0x2c], ecx
            //   83ef01               | sub                 edi, 1
            //   0f85f0fdffff         | jne                 0xfffffdf6
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_2 = { c6857fffffff41 c6458033 c6458141 c6458224 c6458341 c6458420 c6458541 }
            // n = 7, score = 100
            //   c6857fffffff41       | mov                 byte ptr [ebp - 0x81], 0x41
            //   c6458033             | mov                 byte ptr [ebp - 0x80], 0x33
            //   c6458141             | mov                 byte ptr [ebp - 0x7f], 0x41
            //   c6458224             | mov                 byte ptr [ebp - 0x7e], 0x24
            //   c6458341             | mov                 byte ptr [ebp - 0x7d], 0x41
            //   c6458420             | mov                 byte ptr [ebp - 0x7c], 0x20
            //   c6458541             | mov                 byte ptr [ebp - 0x7b], 0x41

        $sequence_3 = { eb08 8b4dc4 e8???????? 8bc6 5e c9 c3 }
            // n = 7, score = 100
            //   eb08                 | jmp                 0xa
            //   8b4dc4               | mov                 ecx, dword ptr [ebp - 0x3c]
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_4 = { c6855cfcffff4d 889d5dfcffff c6855efcffff4c 889d5ffcffff c68560fcffff5b 889d61fcffff 889d62fcffff }
            // n = 7, score = 100
            //   c6855cfcffff4d       | mov                 byte ptr [ebp - 0x3a4], 0x4d
            //   889d5dfcffff         | mov                 byte ptr [ebp - 0x3a3], bl
            //   c6855efcffff4c       | mov                 byte ptr [ebp - 0x3a2], 0x4c
            //   889d5ffcffff         | mov                 byte ptr [ebp - 0x3a1], bl
            //   c68560fcffff5b       | mov                 byte ptr [ebp - 0x3a0], 0x5b
            //   889d61fcffff         | mov                 byte ptr [ebp - 0x39f], bl
            //   889d62fcffff         | mov                 byte ptr [ebp - 0x39e], bl

        $sequence_5 = { 33b1393e5000 8b4c2448 0fb6c9 c1e104 33b9303e5000 33b1343e5000 8b4c2428 }
            // n = 7, score = 100
            //   33b1393e5000         | xor                 esi, dword ptr [ecx + 0x503e39]
            //   8b4c2448             | mov                 ecx, dword ptr [esp + 0x48]
            //   0fb6c9               | movzx               ecx, cl
            //   c1e104               | shl                 ecx, 4
            //   33b9303e5000         | xor                 edi, dword ptr [ecx + 0x503e30]
            //   33b1343e5000         | xor                 esi, dword ptr [ecx + 0x503e34]
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_6 = { 6a3f 5a 6a06 898c244a010000 8db424b8000000 898c2452010000 8dbc2460010000 }
            // n = 7, score = 100
            //   6a3f                 | push                0x3f
            //   5a                   | pop                 edx
            //   6a06                 | push                6
            //   898c244a010000       | mov                 dword ptr [esp + 0x14a], ecx
            //   8db424b8000000       | lea                 esi, [esp + 0xb8]
            //   898c2452010000       | mov                 dword ptr [esp + 0x152], ecx
            //   8dbc2460010000       | lea                 edi, [esp + 0x160]

        $sequence_7 = { 8d143e 03c2 8945f0 8b45cc c1e017 0bc8 8b45cc }
            // n = 7, score = 100
            //   8d143e               | lea                 edx, [esi + edi]
            //   03c2                 | add                 eax, edx
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   c1e017               | shl                 eax, 0x17
            //   0bc8                 | or                  ecx, eax
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]

        $sequence_8 = { 8b45c8 03c3 33d0 c1c210 8d0c16 8b75f4 33d9 }
            // n = 7, score = 100
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   03c3                 | add                 eax, ebx
            //   33d0                 | xor                 edx, eax
            //   c1c210               | rol                 edx, 0x10
            //   8d0c16               | lea                 ecx, [esi + edx]
            //   8b75f4               | mov                 esi, dword ptr [ebp - 0xc]
            //   33d9                 | xor                 ebx, ecx

        $sequence_9 = { c6459025 8bd3 c6459156 c6459223 c6459356 c6459435 }
            // n = 6, score = 100
            //   c6459025             | mov                 byte ptr [ebp - 0x70], 0x25
            //   8bd3                 | mov                 edx, ebx
            //   c6459156             | mov                 byte ptr [ebp - 0x6f], 0x56
            //   c6459223             | mov                 byte ptr [ebp - 0x6e], 0x23
            //   c6459356             | mov                 byte ptr [ebp - 0x6d], 0x56
            //   c6459435             | mov                 byte ptr [ebp - 0x6c], 0x35

    condition:
        7 of them and filesize < 2411520
}