rule win_bedep_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bedep."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bedep"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a02 5f 397df0 7e03 895dfc 837d0800 741f }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   5f                   | pop                 edi
            //   397df0               | cmp                 dword ptr [ebp - 0x10], edi
            //   7e03                 | jle                 5
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   741f                 | je                  0x21

        $sequence_1 = { 8d45a4 50 ff7508 8975fc e8???????? }
            // n = 5, score = 100
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   e8????????           |                     

        $sequence_2 = { e8???????? 8bf0 85f6 59 743c 8a45e0 832600 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   59                   | pop                 ecx
            //   743c                 | je                  0x3e
            //   8a45e0               | mov                 al, byte ptr [ebp - 0x20]
            //   832600               | and                 dword ptr [esi], 0

        $sequence_3 = { eb54 53 6878020000 8d8580fdffff 50 6a01 ff75f8 }
            // n = 7, score = 100
            //   eb54                 | jmp                 0x56
            //   53                   | push                ebx
            //   6878020000           | push                0x278
            //   8d8580fdffff         | lea                 eax, [ebp - 0x280]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_4 = { 85c9 7410 3bd1 740c 8b09 85c9 }
            // n = 6, score = 100
            //   85c9                 | test                ecx, ecx
            //   7410                 | je                  0x12
            //   3bd1                 | cmp                 edx, ecx
            //   740c                 | je                  0xe
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   85c9                 | test                ecx, ecx

        $sequence_5 = { 740b 8d442410 50 ff15???????? 8bc7 5f 5e }
            // n = 7, score = 100
            //   740b                 | je                  0xd
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { e8???????? 8bf0 f7c67fffffff 7729 ff7508 e8???????? 3bf3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   f7c67fffffff         | test                esi, 0xffffff7f
            //   7729                 | ja                  0x2b
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   3bf3                 | cmp                 esi, ebx

        $sequence_7 = { 8b4c2414 8b463c c644240f01 ff742418 ff742420 ff7644 6a01 }
            // n = 7, score = 100
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8b463c               | mov                 eax, dword ptr [esi + 0x3c]
            //   c644240f01           | mov                 byte ptr [esp + 0xf], 1
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   ff7644               | push                dword ptr [esi + 0x44]
            //   6a01                 | push                1

        $sequence_8 = { 40 85c9 7c08 668b4b0c 66014b0a 66894308 5f }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   85c9                 | test                ecx, ecx
            //   7c08                 | jl                  0xa
            //   668b4b0c             | mov                 cx, word ptr [ebx + 0xc]
            //   66014b0a             | add                 word ptr [ebx + 0xa], cx
            //   66894308             | mov                 word ptr [ebx + 8], ax
            //   5f                   | pop                 edi

        $sequence_9 = { ff7638 ff742438 50 8d442450 50 ff742438 8d442438 }
            // n = 7, score = 100
            //   ff7638               | push                dword ptr [esi + 0x38]
            //   ff742438             | push                dword ptr [esp + 0x38]
            //   50                   | push                eax
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   50                   | push                eax
            //   ff742438             | push                dword ptr [esp + 0x38]
            //   8d442438             | lea                 eax, [esp + 0x38]

    condition:
        7 of them and filesize < 557056
}