rule win_bee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bee"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? c706???????? 895618 6689461c 66894e1e ff15???????? }
            // n = 6, score = 100
            //   68????????           |                     
            //   c706????????         |                     
            //   895618               | mov                 dword ptr [esi + 0x18], edx
            //   6689461c             | mov                 word ptr [esi + 0x1c], ax
            //   66894e1e             | mov                 word ptr [esi + 0x1e], cx
            //   ff15????????         |                     

        $sequence_1 = { 3bee 7462 8a46b4 83ee50 83ef50 884704 }
            // n = 6, score = 100
            //   3bee                 | cmp                 ebp, esi
            //   7462                 | je                  0x64
            //   8a46b4               | mov                 al, byte ptr [esi - 0x4c]
            //   83ee50               | sub                 esi, 0x50
            //   83ef50               | sub                 edi, 0x50
            //   884704               | mov                 byte ptr [edi + 4], al

        $sequence_2 = { 83c404 8b8534ffffff 8d0cb6 8d1492 c1e104 03c8 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   8b8534ffffff         | mov                 eax, dword ptr [ebp - 0xcc]
            //   8d0cb6               | lea                 ecx, [esi + esi*4]
            //   8d1492               | lea                 edx, [edx + edx*4]
            //   c1e104               | shl                 ecx, 4
            //   03c8                 | add                 ecx, eax

        $sequence_3 = { b8???????? e8???????? 8b15???????? 3bd3 7504 33c9 }
            // n = 6, score = 100
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b15????????         |                     
            //   3bd3                 | cmp                 edx, ebx
            //   7504                 | jne                 6
            //   33c9                 | xor                 ecx, ecx

        $sequence_4 = { ebc9 8bc8 c1f905 8d1c8d00534200 8bf8 83e71f c1e706 }
            // n = 7, score = 100
            //   ebc9                 | jmp                 0xffffffcb
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8d1c8d00534200       | lea                 ebx, [ecx*4 + 0x425300]
            //   8bf8                 | mov                 edi, eax
            //   83e71f               | and                 edi, 0x1f
            //   c1e706               | shl                 edi, 6

        $sequence_5 = { ffd0 8b4c2410 64890d00000000 59 5f 5e 83c410 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   83c410               | add                 esp, 0x10

        $sequence_6 = { e8???????? 83c404 8b4e7c 51 899e88000000 899e8c000000 899e90000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4e7c               | mov                 ecx, dword ptr [esi + 0x7c]
            //   51                   | push                ecx
            //   899e88000000         | mov                 dword ptr [esi + 0x88], ebx
            //   899e8c000000         | mov                 dword ptr [esi + 0x8c], ebx
            //   899e90000000         | mov                 dword ptr [esi + 0x90], ebx

        $sequence_7 = { 50 8d4c2438 51 8d4c2444 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d4c2438             | lea                 ecx, [esp + 0x38]
            //   51                   | push                ecx
            //   8d4c2444             | lea                 ecx, [esp + 0x44]

        $sequence_8 = { 8d442440 64a300000000 8bf9 833d????????10 a1???????? }
            // n = 5, score = 100
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf9                 | mov                 edi, ecx
            //   833d????????10       |                     
            //   a1????????           |                     

        $sequence_9 = { 7639 0fb654240c 0fb644240d 0fb6c9 034c2414 03c2 }
            // n = 6, score = 100
            //   7639                 | jbe                 0x3b
            //   0fb654240c           | movzx               edx, byte ptr [esp + 0xc]
            //   0fb644240d           | movzx               eax, byte ptr [esp + 0xd]
            //   0fb6c9               | movzx               ecx, cl
            //   034c2414             | add                 ecx, dword ptr [esp + 0x14]
            //   03c2                 | add                 eax, edx

    condition:
        7 of them and filesize < 394240
}