rule win_bernhardpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bernhardpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bernhardpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4508 50 ff15???????? 8945fc c745f800000000 c745f400000000 }
            // n = 6, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0

        $sequence_1 = { 884a02 6a01 ff15???????? 8b8d58feffff }
            // n = 4, score = 200
            //   884a02               | mov                 byte ptr [edx + 2], cl
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8b8d58feffff         | mov                 ecx, dword ptr [ebp - 0x1a8]

        $sequence_2 = { 50 8d8dc8fbffff 51 ff15???????? 6a00 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   8d8dc8fbffff         | lea                 ecx, [ebp - 0x438]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_3 = { 8bec 81ec84040000 53 56 57 6a04 }
            // n = 6, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec84040000         | sub                 esp, 0x484
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a04                 | push                4

        $sequence_4 = { 85c0 0f8488010000 8b45fc 8b4844 51 }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   0f8488010000         | je                  0x18e
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4844               | mov                 ecx, dword ptr [eax + 0x44]
            //   51                   | push                ecx

        $sequence_5 = { 8d8550feffff 50 8d8d5cfeffff 51 6a00 }
            // n = 5, score = 200
            //   8d8550feffff         | lea                 eax, [ebp - 0x1b0]
            //   50                   | push                eax
            //   8d8d5cfeffff         | lea                 ecx, [ebp - 0x1a4]
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_6 = { 8b4dec c1e108 0345e8 03c8 }
            // n = 4, score = 200
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   c1e108               | shl                 ecx, 8
            //   0345e8               | add                 eax, dword ptr [ebp - 0x18]
            //   03c8                 | add                 ecx, eax

        $sequence_7 = { 8b45e4 c1e806 83e03f 8b4d0c 034df4 }
            // n = 5, score = 200
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   c1e806               | shr                 eax, 6
            //   83e03f               | and                 eax, 0x3f
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   034df4               | add                 ecx, dword ptr [ebp - 0xc]

        $sequence_8 = { e8???????? a3???????? 68a86b4aa0 a1???????? 50 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   a3????????           |                     
            //   68a86b4aa0           | push                0xa04a6ba8
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { e8???????? a3???????? 684f5b51f2 a1???????? 50 e8???????? a3???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   a3????????           |                     
            //   684f5b51f2           | push                0xf2515b4f
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   a3????????           |                     

    condition:
        7 of them and filesize < 368640
}