rule win_bert_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bert."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bert"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 488945e8 488b45e8 488945e0 }
            // n = 4, score = 100
            //   ffd0                 | dec                 eax
            //   488945e8             | mov                 eax, dword ptr [ebp - 0x88]
            //   488b45e8             | dec                 eax
            //   488945e0             | mov                 edx, dword ptr [eax]

        $sequence_1 = { 0fb74006 0fb7c0 3945f4 0f8c5efeffff 488b45b8 }
            // n = 5, score = 100
            //   0fb74006             | dec                 eax
            //   0fb7c0               | cwde                
            //   3945f4               | dec                 eax
            //   0f8c5efeffff         | add                 edx, eax
            //   488b45b8             | dec                 eax

        $sequence_2 = { e8???????? 488945f8 488b45f8 4889c1 e8???????? 488945c8 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488945f8             | and                 eax, 0xfff
            //   488b45f8             | mov                 dword ptr [ebp - 0x80], eax
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   488945c8             | mov                 eax, dword ptr [ebp - 0x28]

        $sequence_3 = { 488b8558ffffff 4889c1 488b05???????? ffd0 }
            // n = 4, score = 100
            //   488b8558ffffff       | mov                 ebp, esp
            //   4889c1               | dec                 eax
            //   488b05????????       |                     
            //   ffd0                 | sub                 esp, 0x100

        $sequence_4 = { c745f000000000 e9???????? 8b45f0 4863d0 4889d0 48c1e002 }
            // n = 6, score = 100
            //   c745f000000000       | mov                 edx, dword ptr [eax]
            //   e9????????           |                     
            //   8b45f0               | dec                 eax
            //   4863d0               | add                 edx, eax
            //   4889d0               | dec                 eax
            //   48c1e002             | mov                 eax, dword ptr [ebp - 0x88]

        $sequence_5 = { 48898570ffffff 8b45d0 4863d0 4889d0 48c1e002 4801d0 }
            // n = 6, score = 100
            //   48898570ffffff       | mov                 eax, dword ptr [ebp - 0xa8]
            //   8b45d0               | dec                 eax
            //   4863d0               | mov                 ecx, eax
            //   4889d0               | call                eax
            //   48c1e002             | dec                 eax
            //   4801d0               | lea                 edx, [eax + eax]

        $sequence_6 = { 4883ec10 48894d10 48895518 488b4510 488945f8 488b4518 }
            // n = 6, score = 100
            //   4883ec10             | nop                 
            //   48894d10             | dec                 eax
            //   48895518             | mov                 eax, dword ptr [ebp - 8]
            //   488b4510             | dec                 ecx
            //   488945f8             | mov                 eax, ecx
            //   488b4518             | dec                 eax

        $sequence_7 = { 488945d8 488b45d8 480508010000 488945d0 48c745f800000000 }
            // n = 5, score = 100
            //   488945d8             | dec                 eax
            //   488b45d8             | mov                 eax, dword ptr [ebp - 0x28]
            //   480508010000         | dec                 eax
            //   488945d0             | add                 eax, edx
            //   48c745f800000000     | mov                 eax, dword ptr [eax + 8]

        $sequence_8 = { 4801d0 8b4008 89c1 488d9524ffffff }
            // n = 4, score = 100
            //   4801d0               | mov                 dword ptr [ebp - 0x48], eax
            //   8b4008               | dec                 eax
            //   89c1                 | mov                 eax, dword ptr [ebp - 0x48]
            //   488d9524ffffff       | dec                 eax

        $sequence_9 = { 48c1e810 0fb7c0 4801c2 488b8578ffffff 488910 eb21 488b8578ffffff }
            // n = 7, score = 100
            //   48c1e810             | dec                 eax
            //   0fb7c0               | cwde                
            //   4801c2               | dec                 eax
            //   488b8578ffffff       | add                 edx, eax
            //   488910               | dec                 eax
            //   eb21                 | mov                 eax, dword ptr [ebp - 8]
            //   488b8578ffffff       | dec                 eax

    condition:
        7 of them and filesize < 50176
}