rule win_bitsloth_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bitsloth."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bitsloth"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837de800 740e 8b4de8 8b11 8b45e8 50 }
            // n = 6, score = 100
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   740e                 | je                  0x10
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   50                   | push                eax

        $sequence_1 = { eb44 8b45f4 0345ec 8a48ff 884dfc 8b55f4 0355ec }
            // n = 7, score = 100
            //   eb44                 | jmp                 0x46
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0345ec               | add                 eax, dword ptr [ebp - 0x14]
            //   8a48ff               | mov                 cl, byte ptr [eax - 1]
            //   884dfc               | mov                 byte ptr [ebp - 4], cl
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   0355ec               | add                 edx, dword ptr [ebp - 0x14]

        $sequence_2 = { 52 e8???????? 83c40c 8b45f8 83e801 8945f8 837df803 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   83e801               | sub                 eax, 1
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df803             | cmp                 dword ptr [ebp - 8], 3

        $sequence_3 = { 034df8 8b5508 898a90af0600 8b4508 81b890af060006010000 7310 8b4d08 }
            // n = 7, score = 100
            //   034df8               | add                 ecx, dword ptr [ebp - 8]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   898a90af0600         | mov                 dword ptr [edx + 0x6af90], ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   81b890af060006010000     | cmp    dword ptr [eax + 0x6af90], 0x106
            //   7310                 | jae                 0x12
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_4 = { 8b5104 52 8b01 50 8b4df0 e8???????? c745fc00000000 }
            // n = 7, score = 100
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   52                   | push                edx
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   50                   | push                eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_5 = { eb1b 68???????? 8b4df8 51 e8???????? 83c408 }
            // n = 6, score = 100
            //   eb1b                 | jmp                 0x1d
            //   68????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_6 = { 837df400 751b 6a00 6a00 6812c92300 e8???????? }
            // n = 6, score = 100
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   751b                 | jne                 0x1d
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6812c92300           | push                0x23c912
            //   e8????????           |                     

        $sequence_7 = { 8b4d08 89487c 33c0 8b4dfc 33cd e8???????? 8be5 }
            // n = 7, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   89487c               | mov                 dword ptr [eax + 0x7c], ecx
            //   33c0                 | xor                 eax, eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp

        $sequence_8 = { 6a03 ff15???????? 8985f8ecffff 8d95e4ecffff 52 8d859cecffff 50 }
            // n = 7, score = 100
            //   6a03                 | push                3
            //   ff15????????         |                     
            //   8985f8ecffff         | mov                 dword ptr [ebp - 0x1308], eax
            //   8d95e4ecffff         | lea                 edx, [ebp - 0x131c]
            //   52                   | push                edx
            //   8d859cecffff         | lea                 eax, [ebp - 0x1364]
            //   50                   | push                eax

        $sequence_9 = { 7515 6a00 6a00 68fa920300 e8???????? 83c40c 33c0 }
            // n = 7, score = 100
            //   7515                 | jne                 0x17
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68fa920300           | push                0x392fa
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 677888
}