rule win_bitter_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bitter_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bitter_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 42 00542f42 00cf 2f }
            // n = 4, score = 200
            //   42                   | inc                 edx
            //   00542f42             | add                 byte ptr [edi + ebp + 0x42], dl
            //   00cf                 | add                 bh, cl
            //   2f                   | das                 

        $sequence_1 = { 68d4070000 e8???????? 83c414 a1???????? }
            // n = 4, score = 200
            //   68d4070000           | push                0x7d4
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   a1????????           |                     

        $sequence_2 = { 6a02 6a04 8d85d4fdffff 50 ff15???????? }
            // n = 5, score = 200
            //   6a02                 | push                2
            //   6a04                 | push                4
            //   8d85d4fdffff         | lea                 eax, [ebp - 0x22c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { 83e11f c1e106 8b048500124700 c644080401 57 }
            // n = 5, score = 200
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   8b048500124700       | mov                 eax, dword ptr [eax*4 + 0x471200]
            //   c644080401           | mov                 byte ptr [eax + ecx + 4], 1
            //   57                   | push                edi

        $sequence_4 = { 51 8b954cd9ffff 8d84157cdcffff 50 e8???????? 83c40c 8b854cd9ffff }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   8b954cd9ffff         | mov                 edx, dword ptr [ebp - 0x26b4]
            //   8d84157cdcffff       | lea                 eax, [ebp + edx - 0x2384]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b854cd9ffff         | mov                 eax, dword ptr [ebp - 0x26b4]

        $sequence_5 = { f3ab c745f8???????? b80a000000 668945ec b802000000 668945e0 0fbf45ec }
            // n = 7, score = 200
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   c745f8????????       |                     
            //   b80a000000           | mov                 eax, 0xa
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax
            //   b802000000           | mov                 eax, 2
            //   668945e0             | mov                 word ptr [ebp - 0x20], ax
            //   0fbf45ec             | movsx               eax, word ptr [ebp - 0x14]

        $sequence_6 = { 03048d00124700 eb02 8bc2 f6402480 0f8567ffffff 33c0 }
            // n = 6, score = 200
            //   03048d00124700       | add                 eax, dword ptr [ecx*4 + 0x471200]
            //   eb02                 | jmp                 4
            //   8bc2                 | mov                 eax, edx
            //   f6402480             | test                byte ptr [eax + 0x24], 0x80
            //   0f8567ffffff         | jne                 0xffffff6d
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 03c7 03cf 83ff1f 0f87da030000 ff24bda8864200 8bc6 e9???????? }
            // n = 7, score = 200
            //   03c7                 | add                 eax, edi
            //   03cf                 | add                 ecx, edi
            //   83ff1f               | cmp                 edi, 0x1f
            //   0f87da030000         | ja                  0x3e0
            //   ff24bda8864200       | jmp                 dword ptr [edi*4 + 0x4286a8]
            //   8bc6                 | mov                 eax, esi
            //   e9????????           |                     

        $sequence_8 = { 8bf4 8d8568feffff 50 6a02 ff15???????? 3bf4 }
            // n = 6, score = 200
            //   8bf4                 | mov                 esi, esp
            //   8d8568feffff         | lea                 eax, [ebp - 0x198]
            //   50                   | push                eax
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp

        $sequence_9 = { 8d8d68faffff 51 e8???????? 83c408 8bf4 8d85acfeffff }
            // n = 6, score = 200
            //   8d8d68faffff         | lea                 ecx, [ebp - 0x598]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8bf4                 | mov                 esi, esp
            //   8d85acfeffff         | lea                 eax, [ebp - 0x154]

    condition:
        7 of them and filesize < 1130496
}