rule win_blackbyte_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackbyte."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackbyte"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 498d7101 0f1f440000 4839c6 7ce0 4889c6 41b806000000 }
            // n = 6, score = 200
            //   498d7101             | dec                 eax
            //   0f1f440000           | mov                 ebx, ecx
            //   4839c6               | dec                 ebp
            //   7ce0                 | mov                 esi, eax
            //   4889c6               | dec                 ecx
            //   41b806000000         | mov                 ebx, eax

        $sequence_1 = { 3bc1 7505 e8???????? 4883c304 }
            // n = 4, score = 200
            //   3bc1                 | cmp                 eax, ecx
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   4883c304             | dec                 eax

        $sequence_2 = { 3bc2 72f4 b8ffffffff 4883c420 }
            // n = 4, score = 200
            //   3bc2                 | inc                 bp
            //   72f4                 | test                eax, eax
            //   b8ffffffff           | je                  0x18
            //   4883c420             | nop                 

        $sequence_3 = { 3bc7 7ce0 eb03 488bda }
            // n = 4, score = 200
            //   3bc7                 | xor                 ecx, ecx
            //   7ce0                 | dec                 esp
            //   eb03                 | arpl                ax, cx
            //   488bda               | test                eax, eax

        $sequence_4 = { 3bc1 7f4d 33c9 4c63c8 }
            // n = 4, score = 200
            //   3bc1                 | lea                 ecx, [esp + 0x48]
            //   7f4d                 | inc                 bp
            //   33c9                 | test                eax, eax
            //   4c63c8               | cmp                 eax, ecx

        $sequence_5 = { 4983f851 7553 4c8d4002 4c39c1 }
            // n = 4, score = 200
            //   4983f851             | je                  0x94
            //   7553                 | dec                 eax
            //   4c8d4002             | lea                 eax, [esp + 0x5c]
            //   4c39c1               | cmp                 eax, edi

        $sequence_6 = { 4989c3 4889cf 488b4c2428 48897c2450 4c895c2468 4b8d0413 90 }
            // n = 7, score = 200
            //   4989c3               | jg                  0x31
            //   4889cf               | dec                 esp
            //   488b4c2428           | arpl                ax, bx
            //   48897c2450           | test                eax, eax
            //   4c895c2468           | jle                 0x24
            //   4b8d0413             | mov                 edx, edi
            //   90                   | dec                 ebp

        $sequence_7 = { 4983f803 0f8f66010000 90 4983f801 0f8fb6000000 }
            // n = 5, score = 200
            //   4983f803             | dec                 esp
            //   0f8f66010000         | mov                 dword ptr [esp + 0x68], ebx
            //   90                   | dec                 ebx
            //   4983f801             | lea                 eax, [ebx + edx]
            //   0f8fb6000000         | nop                 

        $sequence_8 = { 3bc2 7f2f 4c63d8 85c0 }
            // n = 4, score = 200
            //   3bc2                 | dec                 eax
            //   7f2f                 | add                 ecx, 2
            //   4c63d8               | cmp                 eax, ecx
            //   85c0                 | jg                  0x4f

        $sequence_9 = { 0f1005???????? 4c8960e0 4533e4 4c8968d8 }
            // n = 4, score = 200
            //   0f1005????????       |                     
            //   4c8960e0             | add                 ebx, 4
            //   4533e4               | dec                 esp
            //   4c8968d8             | mov                 dword ptr [eax - 0x20], esp

        $sequence_10 = { 4983f805 0f8511020000 4c8d4304 4c39c6 }
            // n = 4, score = 200
            //   4983f805             | dec                 eax
            //   0f8511020000         | mov                 eax, dword ptr [esp + 0xb0]
            //   4c8d4304             | dec                 eax
            //   4c39c6               | mov                 ecx, dword ptr [esp + 0x68]

        $sequence_11 = { 493b6610 0f8626010000 4883ec70 48896c2468 488d6c2468 }
            // n = 5, score = 200
            //   493b6610             | push                edi
            //   0f8626010000         | dec                 eax
            //   4883ec70             | lea                 ebp, [esp - 0x37]
            //   48896c2468           | dec                 eax
            //   488d6c2468           | sub                 esp, 0xe0

        $sequence_12 = { 3bc1 7573 488d4c2448 664585c0 }
            // n = 4, score = 200
            //   3bc1                 | test                dx, dx
            //   7573                 | je                  0x12
            //   488d4c2448           | cmp                 eax, ecx
            //   664585c0             | jne                 0x5c

        $sequence_13 = { 3bc1 7558 498bcb 6685d2 }
            // n = 4, score = 200
            //   3bc1                 | mov                 dword ptr [eax - 0x28], ebp
            //   7558                 | inc                 ecx
            //   498bcb               | mov                 ebx, esp
            //   6685d2               | dec                 esp

        $sequence_14 = { 4989c3 488b8424b0000000 e8???????? 488b4c2468 }
            // n = 4, score = 200
            //   4989c3               | sub                 ecx, edx
            //   488b8424b0000000     | cmp                 eax, edi
            //   e8????????           |                     
            //   488b4c2468           | jl                  0xffffffe2

        $sequence_15 = { 493b6610 767b 4883ec38 48896c2430 488d6c2430 4889442440 49c7c500000000 }
            // n = 7, score = 200
            //   493b6610             | je                  0x94
            //   767b                 | cmp                 eax, edi
            //   4883ec38             | jl                  0xffffffe2
            //   48896c2430           | jmp                 7
            //   488d6c2430           | dec                 eax
            //   4889442440           | mov                 ebx, edx
            //   49c7c500000000       | cmp                 word ptr [ebx], 0

    condition:
        7 of them and filesize < 9435136
}