rule win_blackcat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackcat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackcat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4701 31c9 31d2 89460c 4f c745f000000000 }
            // n = 6, score = 600
            //   8d4701               | lea                 eax, [edi + 1]
            //   31c9                 | xor                 ecx, ecx
            //   31d2                 | xor                 edx, edx
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   4f                   | dec                 edi
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0

        $sequence_1 = { 3c02 7351 88c4 8975cc }
            // n = 4, score = 600
            //   3c02                 | cmp                 al, 2
            //   7351                 | jae                 0x53
            //   88c4                 | mov                 ah, al
            //   8975cc               | mov                 dword ptr [ebp - 0x34], esi

        $sequence_2 = { 8945e8 0f83a1000000 85db 0f8499000000 803c3b5f }
            // n = 5, score = 600
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   0f83a1000000         | jae                 0xa7
            //   85db                 | test                ebx, ebx
            //   0f8499000000         | je                  0x9f
            //   803c3b5f             | cmp                 byte ptr [ebx + edi], 0x5f

        $sequence_3 = { 81f902010000 747b e9???????? 8d81d6c3ffff 83f802 726b 81f9ed350000 }
            // n = 7, score = 600
            //   81f902010000         | cmp                 ecx, 0x102
            //   747b                 | je                  0x7d
            //   e9????????           |                     
            //   8d81d6c3ffff         | lea                 eax, [ecx - 0x3c2a]
            //   83f802               | cmp                 eax, 2
            //   726b                 | jb                  0x6d
            //   81f9ed350000         | cmp                 ecx, 0x35ed

        $sequence_4 = { 31f6 c70201000000 c7420400000000 894208 c7420c00000000 0fb788d6040000 }
            // n = 6, score = 600
            //   31f6                 | xor                 esi, esi
            //   c70201000000         | mov                 dword ptr [edx], 1
            //   c7420400000000       | mov                 dword ptr [edx + 4], 0
            //   894208               | mov                 dword ptr [edx + 8], eax
            //   c7420c00000000       | mov                 dword ptr [edx + 0xc], 0
            //   0fb788d6040000       | movzx               ecx, word ptr [eax + 0x4d6]

        $sequence_5 = { c1e203 662e0f1f840000000000 90 85d2 7411 8b39 83c108 }
            // n = 7, score = 600
            //   c1e203               | shl                 edx, 3
            //   662e0f1f840000000000     | nop    word ptr cs:[eax + eax]
            //   90                   | nop                 
            //   85d2                 | test                edx, edx
            //   7411                 | je                  0x13
            //   8b39                 | mov                 edi, dword ptr [ecx]
            //   83c108               | add                 ecx, 8

        $sequence_6 = { 0f1f840000000000 6690 55 89e5 }
            // n = 4, score = 600
            //   0f1f840000000000     | nop                 dword ptr [eax + eax]
            //   6690                 | nop                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp

        $sequence_7 = { 8b450c 89d6 8a10 80c2e6 80fa05 7779 }
            // n = 6, score = 600
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   89d6                 | mov                 esi, edx
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   80c2e6               | add                 dl, 0xe6
            //   80fa05               | cmp                 dl, 5
            //   7779                 | ja                  0x7b

        $sequence_8 = { 80c230 8894056bffffff 48 e9???????? }
            // n = 4, score = 600
            //   80c230               | add                 dl, 0x30
            //   8894056bffffff       | mov                 byte ptr [ebp + eax - 0x95], dl
            //   48                   | dec                 eax
            //   e9????????           |                     

        $sequence_9 = { 83c40c 84c0 0f858b010000 8d4704 }
            // n = 4, score = 600
            //   83c40c               | add                 esp, 0xc
            //   84c0                 | test                al, al
            //   0f858b010000         | jne                 0x191
            //   8d4704               | lea                 eax, [edi + 4]

    condition:
        7 of them and filesize < 29981696
}