rule win_blackcoffee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackcoffee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackcoffee"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff75fc 57 6a01 ff15???????? 8bd8 3bdf }
            // n = 6, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   57                   | push                edi
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bdf                 | cmp                 ebx, edi

        $sequence_1 = { 53 e8???????? 83c40c ffd3 3bc7 7460 8b5610 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ffd3                 | call                ebx
            //   3bc7                 | cmp                 eax, edi
            //   7460                 | je                  0x62
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]

        $sequence_2 = { 897dfc 8945f4 50 8d4610 }
            // n = 4, score = 200
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   50                   | push                eax
            //   8d4610               | lea                 eax, [esi + 0x10]

        $sequence_3 = { 50 c70614000000 ff15???????? 8d85dcfeffff 83c40c 8945e8 8d45e0 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   c70614000000         | mov                 dword ptr [esi], 0x14
            //   ff15????????         |                     
            //   8d85dcfeffff         | lea                 eax, [ebp - 0x124]
            //   83c40c               | add                 esp, 0xc
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]

        $sequence_4 = { c68501f0ffff36 c68502f0ffff34 c68503f0ffff50 c68504f0ffff72 }
            // n = 4, score = 200
            //   c68501f0ffff36       | mov                 byte ptr [ebp - 0xfff], 0x36
            //   c68502f0ffff34       | mov                 byte ptr [ebp - 0xffe], 0x34
            //   c68503f0ffff50       | mov                 byte ptr [ebp - 0xffd], 0x50
            //   c68504f0ffff72       | mov                 byte ptr [ebp - 0xffc], 0x72

        $sequence_5 = { 8b45fc 89460c c70614000000 e9???????? 83660c00 8d85b4feffff 50 }
            // n = 7, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   c70614000000         | mov                 dword ptr [esi], 0x14
            //   e9????????           |                     
            //   83660c00             | and                 dword ptr [esi + 0xc], 0
            //   8d85b4feffff         | lea                 eax, [ebp - 0x14c]
            //   50                   | push                eax

        $sequence_6 = { 6800800000 57 53 ff15???????? 8b4610 }
            // n = 5, score = 200
            //   6800800000           | push                0x8000
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]

        $sequence_7 = { e8???????? 8806 8d45b0 50 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8806                 | mov                 byte ptr [esi], al
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax

        $sequence_8 = { 897dfc 57 ff15???????? 8bd8 3bdf 747a 8b460c }
            // n = 7, score = 200
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bdf                 | cmp                 ebx, edi
            //   747a                 | je                  0x7c
            //   8b460c               | mov                 eax, dword ptr [esi + 0xc]

        $sequence_9 = { 895efc ff75f8 56 e8???????? 83c40c 56 }
            // n = 6, score = 200
            //   895efc               | mov                 dword ptr [esi - 4], ebx
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi

    condition:
        7 of them and filesize < 118784
}