rule win_blackenergy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackenergy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackenergy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89430c 8bc3 5f 5b }
            // n = 4, score = 200
            //   89430c               | mov                 dword ptr [ebx + 0xc], eax
            //   8bc3                 | mov                 eax, ebx
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_1 = { 56 e8???????? 8bf0 85f6 7417 56 6a00 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7417                 | je                  0x19
            //   56                   | push                esi
            //   6a00                 | push                0

        $sequence_2 = { e8???????? 85c0 0f848c130000 8945b4 8b7508 8b7d10 8b4d0c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f848c130000         | je                  0x1392
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_3 = { c70200000000 8b5104 0bd2 7407 c7420800000000 5a }
            // n = 6, score = 200
            //   c70200000000         | mov                 dword ptr [edx], 0
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   0bd2                 | or                  edx, edx
            //   7407                 | je                  9
            //   c7420800000000       | mov                 dword ptr [edx + 8], 0
            //   5a                   | pop                 edx

        $sequence_4 = { 49 8bc3 2bc1 40 5b 5f 8bd0 }
            // n = 7, score = 200
            //   49                   | dec                 ecx
            //   8bc3                 | mov                 eax, ebx
            //   2bc1                 | sub                 eax, ecx
            //   40                   | inc                 eax
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   8bd0                 | mov                 edx, eax

        $sequence_5 = { 53 e8???????? 6a00 ffd0 8b5f3c 8365c800 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   e8????????           |                     
            //   6a00                 | push                0
            //   ffd0                 | call                eax
            //   8b5f3c               | mov                 ebx, dword ptr [edi + 0x3c]
            //   8365c800             | and                 dword ptr [ebp - 0x38], 0

        $sequence_6 = { 47 38e0 74f1 3bca 7602 }
            // n = 5, score = 200
            //   47                   | inc                 edi
            //   38e0                 | cmp                 al, ah
            //   74f1                 | je                  0xfffffff3
            //   3bca                 | cmp                 ecx, edx
            //   7602                 | jbe                 4

        $sequence_7 = { ff15???????? c3 55 8bec 81ec08010000 8365fc00 57 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec08010000         | sub                 esp, 0x108
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   57                   | push                edi

        $sequence_8 = { 83f905 770b c745f409000000 33c9 }
            // n = 4, score = 200
            //   83f905               | cmp                 ecx, 5
            //   770b                 | ja                  0xd
            //   c745f409000000       | mov                 dword ptr [ebp - 0xc], 9
            //   33c9                 | xor                 ecx, ecx

        $sequence_9 = { ff75c4 51 6a00 ff7514 56 ff7508 }
            // n = 6, score = 200
            //   ff75c4               | push                dword ptr [ebp - 0x3c]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   56                   | push                esi
            //   ff7508               | push                dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 98304
}