rule win_blacklotus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blacklotus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blacklotus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 884102 488d4904 4983e801 75dc 428d149dfcffffff 460fb60412 8d4201 }
            // n = 7, score = 100
            //   884102               | shr                 eax, 1
            //   488d4904             | je                  0xb42
            //   4983e801             | jb                  0xad0
            //   75dc                 | jmp                 0xb0d
            //   428d149dfcffffff     | inc                 ebp
            //   460fb60412           | mov                 ecx, edx
            //   8d4201               | dec                 esp

        $sequence_1 = { 7507 488b4b38 c601c3 488b1b 483bdf }
            // n = 5, score = 100
            //   7507                 | xor                 ecx, ecx
            //   488b4b38             | mov                 byte ptr [eax + esi + 0x7d8], dl
            //   c601c3               | inc                 ecx
            //   488b1b               | lea                 eax, [ecx + 1]
            //   483bdf               | inc                 edx

        $sequence_2 = { 4883c104 e8???????? 488b4d30 0fb65103 0fb64102 48c1e208 }
            // n = 6, score = 100
            //   4883c104             | lea                 ecx, [esp + 0x40]
            //   e8????????           |                     
            //   488b4d30             | test                esi, esi
            //   0fb65103             | je                  0x18fc
            //   0fb64102             | dec                 esp
            //   48c1e208             | lea                 eax, [esp + 0x70]

        $sequence_3 = { 44884301 88430b e8???????? 4c8bc6 488bd3 408acf }
            // n = 6, score = 100
            //   44884301             | js                  0x1296
            //   88430b               | inc                 edx
            //   e8????????           |                     
            //   4c8bc6               | lea                 ecx, [edx + edx]
            //   488bd3               | sar                 ecx, 1
            //   408acf               | dec                 eax

        $sequence_4 = { 2bcf ffc7 4103c9 6633544d08 8d41ff 6689544508 }
            // n = 6, score = 100
            //   2bcf                 | inc                 ebp
            //   ffc7                 | xor                 eax, eax
            //   4103c9               | xor                 edx, edx
            //   6633544d08           | call                dword ptr [esi + 0xd0]
            //   8d41ff               | dec                 eax
            //   6689544508           | test                eax, eax

        $sequence_5 = { 408a7c3c30 428d149de0ffffff 46320412 8d4201 }
            // n = 4, score = 100
            //   408a7c3c30           | dec                 ecx
            //   428d149de0ffffff     | mov                 ecx, ecx
            //   46320412             | dec                 eax
            //   8d4201               | mov                 esi, dword ptr [esp + 0x38]

        $sequence_6 = { 4883ec30 418be8 488bfa 488bf1 488d15d41a0100 488b0d???????? }
            // n = 6, score = 100
            //   4883ec30             | lea                 ecx, [esp + 0x30]
            //   418be8               | dec                 eax
            //   488bfa               | mov                 edx, ebx
            //   488bf1               | dec                 eax
            //   488d15d41a0100       | lea                 edx, [esp + 0x40]
            //   488b0d????????       |                     

        $sequence_7 = { 7508 4d85c0 75ea 33c0 c3 1bc0 }
            // n = 6, score = 100
            //   7508                 | test                eax, eax
            //   4d85c0               | je                  0x639
            //   75ea                 | dec                 eax
            //   33c0                 | mov                 ecx, dword ptr [ecx + 0x40]
            //   c3                   | cmp                 eax, 0x1db0
            //   1bc0                 | jb                  0x5b1

        $sequence_8 = { ffc8 03c3 44888430d8070000 453bd1 72b9 8b15???????? ffca }
            // n = 7, score = 100
            //   ffc8                 | mov                 dword ptr [ebp - 0x78], 0x39becb6a
            //   03c3                 | mov                 dword ptr [ebp - 0x74], 0xcf584c4a
            //   44888430d8070000     | mov                 dword ptr [ebp - 0x70], 0xfbaaefd0
            //   453bd1               | mov                 dword ptr [ebp], 0x66b53e70
            //   72b9                 | mov                 dword ptr [ebp + 4], 0xef60348
            //   8b15????????         |                     
            //   ffca                 | mov                 dword ptr [ebp + 8], 0xb9573561

        $sequence_9 = { 4c8d054e140100 488bd7 488bd8 e8???????? 488b05???????? }
            // n = 5, score = 100
            //   4c8d054e140100       | movzx               eax, ax
            //   488bd7               | dec                 ecx
            //   488bd8               | lea                 edx, [ecx + 0x14]
            //   e8????????           |                     
            //   488b05????????       |                     

    condition:
        7 of them and filesize < 181248
}