rule win_blackmatter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackmatter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackmatter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? ebe7 837dd400 7408 ff75d4 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   ebe7                 | jmp                 0xffffffe9
            //   837dd400             | cmp                 dword ptr [ebp - 0x2c], 0
            //   7408                 | je                  0xa
            //   ff75d4               | push                dword ptr [ebp - 0x2c]

        $sequence_1 = { 807eff2e 7502 eb02 eb05 }
            // n = 4, score = 400
            //   807eff2e             | cmp                 byte ptr [esi - 1], 0x2e
            //   7502                 | jne                 4
            //   eb02                 | jmp                 4
            //   eb05                 | jmp                 7

        $sequence_2 = { 8d45f4 50 ff15???????? 83c40c 6a0a }
            // n = 5, score = 400
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a0a                 | push                0xa

        $sequence_3 = { 0f858c000000 83bdacfdffff00 7509 83bdb0fdffff00 747a }
            // n = 5, score = 400
            //   0f858c000000         | jne                 0x92
            //   83bdacfdffff00       | cmp                 dword ptr [ebp - 0x254], 0
            //   7509                 | jne                 0xb
            //   83bdb0fdffff00       | cmp                 dword ptr [ebp - 0x250], 0
            //   747a                 | je                  0x7c

        $sequence_4 = { 740e ff75f0 ff15???????? 5b 8be5 }
            // n = 5, score = 400
            //   740e                 | je                  0x10
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_5 = { ff15???????? 85c0 753a 64813d34000000b7000000 }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   753a                 | jne                 0x3c
            //   64813d34000000b7000000     | cmp    dword ptr fs:[0x34], 0xb7

        $sequence_6 = { c745f000000000 ff7508 ff15???????? 83c404 85c0 0f848a010000 }
            // n = 6, score = 400
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f848a010000         | je                  0x190

        $sequence_7 = { 66ab 648b1d30000000 ff731c ff15???????? 8b7310 8d4638 ff35???????? }
            // n = 7, score = 400
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   648b1d30000000       | mov                 ebx, dword ptr fs:[0x30]
            //   ff731c               | push                dword ptr [ebx + 0x1c]
            //   ff15????????         |                     
            //   8b7310               | mov                 esi, dword ptr [ebx + 0x10]
            //   8d4638               | lea                 eax, [esi + 0x38]
            //   ff35????????         |                     

        $sequence_8 = { 85f6 745e 687c010000 56 ff75e8 ff15???????? }
            // n = 6, score = 400
            //   85f6                 | test                esi, esi
            //   745e                 | je                  0x60
            //   687c010000           | push                0x17c
            //   56                   | push                esi
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff15????????         |                     

        $sequence_9 = { 85c0 7510 807eff2d 7406 807eff2e 7502 eb02 }
            // n = 7, score = 400
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12
            //   807eff2d             | cmp                 byte ptr [esi - 1], 0x2d
            //   7406                 | je                  8
            //   807eff2e             | cmp                 byte ptr [esi - 1], 0x2e
            //   7502                 | jne                 4
            //   eb02                 | jmp                 4

    condition:
        7 of them and filesize < 194560
}