rule win_blackpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blackpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blackpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8d85d0fcffff 50 56 ff15???????? }
            // n = 5, score = 100
            //   56                   | push                esi
            //   8d85d0fcffff         | lea                 eax, [ebp - 0x330]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_1 = { 837e1400 0f8e94010000 83a5f8fffdff00 8b7e08 83661400 }
            // n = 5, score = 100
            //   837e1400             | cmp                 dword ptr [esi + 0x14], 0
            //   0f8e94010000         | jle                 0x19a
            //   83a5f8fffdff00       | and                 dword ptr [ebp - 0x20008], 0
            //   8b7e08               | mov                 edi, dword ptr [esi + 8]
            //   83661400             | and                 dword ptr [esi + 0x14], 0

        $sequence_2 = { 8d7de0 f3a5 a4 be00020000 }
            // n = 4, score = 100
            //   8d7de0               | lea                 edi, [ebp - 0x20]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   be00020000           | mov                 esi, 0x200

        $sequence_3 = { 8365bc00 8365c000 8945b4 8d45b4 50 }
            // n = 5, score = 100
            //   8365bc00             | and                 dword ptr [ebp - 0x44], 0
            //   8365c000             | and                 dword ptr [ebp - 0x40], 0
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   8d45b4               | lea                 eax, [ebp - 0x4c]
            //   50                   | push                eax

        $sequence_4 = { 53 50 889db8fcffff e8???????? 57 68???????? }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   50                   | push                eax
            //   889db8fcffff         | mov                 byte ptr [ebp - 0x348], bl
            //   e8????????           |                     
            //   57                   | push                edi
            //   68????????           |                     

        $sequence_5 = { f7f9 8b4dfc 5f 5e 5b 8bc2 }
            // n = 6, score = 100
            //   f7f9                 | idiv                ecx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8bc2                 | mov                 eax, edx

        $sequence_6 = { 8a843dfefffdff 3ac1 7211 3c3a }
            // n = 4, score = 100
            //   8a843dfefffdff       | mov                 al, byte ptr [ebp + edi - 0x20002]
            //   3ac1                 | cmp                 al, cl
            //   7211                 | jb                  0x13
            //   3c3a                 | cmp                 al, 0x3a

        $sequence_7 = { 803e00 7522 8d041f 6a01 8d8405e5fbffff 50 56 }
            // n = 7, score = 100
            //   803e00               | cmp                 byte ptr [esi], 0
            //   7522                 | jne                 0x24
            //   8d041f               | lea                 eax, [edi + ebx]
            //   6a01                 | push                1
            //   8d8405e5fbffff       | lea                 eax, [ebp + eax - 0x41b]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_8 = { 8bc8 83e01f c1f905 c1e006 03048d60c45800 eb02 8bc2 }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   c1e006               | shl                 eax, 6
            //   03048d60c45800       | add                 eax, dword ptr [ecx*4 + 0x58c460]
            //   eb02                 | jmp                 4
            //   8bc2                 | mov                 eax, edx

        $sequence_9 = { 899dbcfaffff c785c0faffffa0bb0d00 c785c4faffff90854100 ffd7 8d85c4faffff 50 }
            // n = 6, score = 100
            //   899dbcfaffff         | mov                 dword ptr [ebp - 0x544], ebx
            //   c785c0faffffa0bb0d00     | mov    dword ptr [ebp - 0x540], 0xdbba0
            //   c785c4faffff90854100     | mov    dword ptr [ebp - 0x53c], 0x418590
            //   ffd7                 | call                edi
            //   8d85c4faffff         | lea                 eax, [ebp - 0x53c]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 3293184
}