rule win_blacksoul_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blacksoul."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blacksoul"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 894dcc 668945b8 c645fc01 8b450c }
            // n = 4, score = 200
            //   894dcc               | mov                 dword ptr [ebp - 0x34], ecx
            //   668945b8             | mov                 word ptr [ebp - 0x48], ax
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_1 = { 59 83f816 733d 8b4d94 398d70ffffff 7f05 ff4598 }
            // n = 7, score = 200
            //   59                   | pop                 ecx
            //   83f816               | cmp                 eax, 0x16
            //   733d                 | jae                 0x3f
            //   8b4d94               | mov                 ecx, dword ptr [ebp - 0x6c]
            //   398d70ffffff         | cmp                 dword ptr [ebp - 0x90], ecx
            //   7f05                 | jg                  7
            //   ff4598               | inc                 dword ptr [ebp - 0x68]

        $sequence_2 = { 6a08 8d4dd0 e8???????? 8b750c 895f4c }
            // n = 5, score = 200
            //   6a08                 | push                8
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   895f4c               | mov                 dword ptr [edi + 0x4c], ebx

        $sequence_3 = { ff37 e8???????? 59 59 eb24 8b37 8bce }
            // n = 7, score = 200
            //   ff37                 | push                dword ptr [edi]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   eb24                 | jmp                 0x26
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   8bce                 | mov                 ecx, esi

        $sequence_4 = { 83c602 88459f 53 897580 894594 }
            // n = 5, score = 200
            //   83c602               | add                 esi, 2
            //   88459f               | mov                 byte ptr [ebp - 0x61], al
            //   53                   | push                ebx
            //   897580               | mov                 dword ptr [ebp - 0x80], esi
            //   894594               | mov                 dword ptr [ebp - 0x6c], eax

        $sequence_5 = { 894590 e8???????? 59 59 84c0 0f84eb000000 807b0400 }
            // n = 7, score = 200
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   84c0                 | test                al, al
            //   0f84eb000000         | je                  0xf1
            //   807b0400             | cmp                 byte ptr [ebx + 4], 0

        $sequence_6 = { ffd6 8bbd7cffffff 8bb578ffffff 57 53 }
            // n = 5, score = 200
            //   ffd6                 | call                esi
            //   8bbd7cffffff         | mov                 edi, dword ptr [ebp - 0x84]
            //   8bb578ffffff         | mov                 esi, dword ptr [ebp - 0x88]
            //   57                   | push                edi
            //   53                   | push                ebx

        $sequence_7 = { 85ff 7517 68a1030000 68???????? }
            // n = 4, score = 200
            //   85ff                 | test                edi, edi
            //   7517                 | jne                 0x19
            //   68a1030000           | push                0x3a1
            //   68????????           |                     

        $sequence_8 = { 8d45a4 7203 8b45a4 84d2 7464 85ff 7451 }
            // n = 7, score = 200
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   7203                 | jb                  5
            //   8b45a4               | mov                 eax, dword ptr [ebp - 0x5c]
            //   84d2                 | test                dl, dl
            //   7464                 | je                  0x66
            //   85ff                 | test                edi, edi
            //   7451                 | je                  0x53

        $sequence_9 = { 7443 8d4d10 51 8d4d16 51 8d4d14 51 }
            // n = 7, score = 200
            //   7443                 | je                  0x45
            //   8d4d10               | lea                 ecx, [ebp + 0x10]
            //   51                   | push                ecx
            //   8d4d16               | lea                 ecx, [ebp + 0x16]
            //   51                   | push                ecx
            //   8d4d14               | lea                 ecx, [ebp + 0x14]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 1823640
}