rule win_blind_edr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.blind_edr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.blind_edr"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bcf e8???????? 488bc5 e9???????? 498b6e18 488bcf e8???????? }
            // n = 7, score = 100
            //   488bcf               | push                edi
            //   e8????????           |                     
            //   488bc5               | dec                 eax
            //   e9????????           |                     
            //   498b6e18             | sub                 esp, 0x20
            //   488bcf               | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { 483b442468 75d7 85db 7e58 }
            // n = 4, score = 100
            //   483b442468           | inc                 ebp
            //   75d7                 | xor                 ecx, ecx
            //   85db                 | dec                 eax
            //   7e58                 | mov                 dword ptr [ebp - 0x60], ecx

        $sequence_2 = { 498b84ffe0fc0100 90 493bc6 0f84ae000000 4885c0 0f85a7000000 4d3bc1 }
            // n = 7, score = 100
            //   498b84ffe0fc0100     | mov                 edi, eax
            //   90                   | dec                 eax
            //   493bc6               | mov                 edi, eax
            //   0f84ae000000         | dec                 eax
            //   4885c0               | test                eax, eax
            //   0f85a7000000         | je                  0x1081
            //   4d3bc1               | mov                 dword ptr [eax], 0xdddd

        $sequence_3 = { 488d8c24b0000000 41b808000000 488bd3 e8???????? 4883c308 4883ef01 0f8560ffffff }
            // n = 7, score = 100
            //   488d8c24b0000000     | mov                 eax, dword ptr [esi + ebx*8 + 0x1e020]
            //   41b808000000         | dec                 eax
            //   488bd3               | inc                 ebx
            //   e8????????           |                     
            //   4883c308             | dec                 eax
            //   4883ef01             | mov                 edx, eax
            //   0f8560ffffff         | dec                 eax

        $sequence_4 = { 488d542450 4533c9 41b802000000 488d4b02 e8???????? 6639742450 747a }
            // n = 7, score = 100
            //   488d542450           | dec                 eax
            //   4533c9               | mov                 ebx, dword ptr [esp + 0x50]
            //   41b802000000         | dec                 eax
            //   488d4b02             | mov                 esi, dword ptr [esp + 0x60]
            //   e8????????           |                     
            //   6639742450           | dec                 eax
            //   747a                 | add                 esp, 0x30

        $sequence_5 = { 488d4b10 4533c9 41b808000000 488d542448 }
            // n = 4, score = 100
            //   488d4b10             | mov                 edx, 0x64dd6c03
            //   4533c9               | dec                 eax
            //   41b808000000         | mov                 esi, eax
            //   488d542448           | dec                 eax

        $sequence_6 = { 745e 4883c108 4c89b424a8000000 4533c9 488d9424a8000000 }
            // n = 5, score = 100
            //   745e                 | inc                 ecx
            //   4883c108             | mov                 eax, 8
            //   4c89b424a8000000     | dec                 eax
            //   4533c9               | mov                 eax, dword ptr [ebp - 0x50]
            //   488d9424a8000000     | nop                 

        $sequence_7 = { 4883ec20 488bda 4c8d0d20fd0000 8bf9 488d1517fd0000 }
            // n = 5, score = 100
            //   4883ec20             | sbb                 ecx, ecx
            //   488bda               | dec                 eax
            //   4c8d0d20fd0000       | and                 ecx, eax
            //   8bf9                 | je                  0x4be
            //   488d1517fd0000       | dec                 eax

        $sequence_8 = { e8???????? 4533c9 4c89742460 41b808000000 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   4533c9               | test                eax, eax
            //   4c89742460           | je                  0x16f
            //   41b808000000         | mov                 edx, 0x5db9c22c

        $sequence_9 = { 4c8d0503fd0000 e8???????? 488bd3 8bcf 4885c0 7408 ff15???????? }
            // n = 7, score = 100
            //   4c8d0503fd0000       | sub                 esp, 0x20
            //   e8????????           |                     
            //   488bd3               | dec                 eax
            //   8bcf                 | mov                 ebx, ecx
            //   4885c0               | dec                 esp
            //   7408                 | lea                 ecx, [0xb4e0]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 299008
}